/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.util.Date;
import java.util.List;
import org.restlet.data.CookieSetting;
import org.restlet.engine.header.HeaderWriter;
import org.restlet.engine.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieSettingWriter
extends HeaderWriter<CookieSetting> {
    public static String write(CookieSetting cookieSetting) {
        return new CookieSettingWriter().append(cookieSetting).toString();
    }

    public static String write(List<CookieSetting> cookieSettings) {
        return ((HeaderWriter)new CookieSettingWriter()).append(cookieSettings).toString();
    }

    public CookieSettingWriter append(CookieSetting cookieSetting) throws IllegalArgumentException {
        String comment;
        int maxAge;
        String path;
        String name = cookieSetting.getName();
        String value = cookieSetting.getValue();
        int version = cookieSetting.getVersion();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Can't write cookie. Invalid name detected");
        }
        ((HeaderWriter)this.append(name)).append('=');
        if (value != null && value.length() > 0) {
            this.appendValue(value, version);
        }
        if (version > 0) {
            this.append("; Version=");
            this.appendValue(Integer.toString(version), version);
        }
        if ((path = cookieSetting.getPath()) != null && path.length() > 0) {
            this.append("; Path=");
            if (version == 0) {
                this.append(path);
            } else {
                this.appendQuotedString(path);
            }
        }
        if ((maxAge = cookieSetting.getMaxAge()) >= 0) {
            if (version == 0) {
                long currentTime = System.currentTimeMillis();
                long maxTime = (long)maxAge * 1000L;
                long expiresTime = currentTime + maxTime;
                Date expires = new Date(expiresTime);
                this.append("; Expires=");
                this.appendValue(DateUtils.format(expires, DateUtils.FORMAT_RFC_1036.get(0)), version);
            } else {
                this.append("; Max-Age=");
                this.appendValue(Integer.toString(cookieSetting.getMaxAge()), version);
            }
        } else if (maxAge == -1 && version > 0) {
            this.append("; Discard");
        }
        String domain = cookieSetting.getDomain();
        if (domain != null && domain.length() > 0) {
            this.append("; Domain=");
            this.appendValue(domain.toLowerCase(), version);
        }
        if (cookieSetting.isSecure()) {
            this.append("; Secure");
        }
        if (cookieSetting.isAccessRestricted()) {
            this.append("; HttpOnly");
        }
        if (version > 0 && (comment = cookieSetting.getComment()) != null && comment.length() > 0) {
            this.append("; Comment=");
            this.appendValue(comment, version);
        }
        return this;
    }

    public CookieSettingWriter appendValue(String value, int version) {
        if (version == 0) {
            this.append(value.toString());
        } else {
            this.appendQuotedString(value);
        }
        return this;
    }
}

