/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.connector.ConnectionState;
import org.restlet.engine.connector.Controller;
import org.restlet.engine.io.IoState;
import org.restlet.util.SelectionListener;
import org.restlet.util.SelectionRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionController
extends Controller
implements Runnable {
    private volatile Selector selector;
    private final Queue<SelectionRegistration> newRegistrations = new ConcurrentLinkedQueue<SelectionRegistration>();
    private final Queue<SelectionRegistration> updatedRegistrations = new ConcurrentLinkedQueue<SelectionRegistration>();

    public ConnectionController(ConnectionHelper<?> helper) {
        super(helper);
    }

    protected void controlConnections() throws IOException {
        for (Connection<?> conn : this.getHelper().getConnections()) {
            if (this.getHelper().getLogger().isLoggable(Level.FINEST)) {
                this.getHelper().getLogger().log(Level.FINEST, "Connection status: " + conn);
            }
            if (conn.getState() == ConnectionState.CLOSED) {
                this.getHelper().getConnections().remove(conn);
                this.getHelper().checkin(conn);
                continue;
            }
            if (conn.getState() == ConnectionState.CLOSING && conn.isEmpty()) {
                conn.close(false);
                continue;
            }
            if (conn.hasTimedOut()) {
                conn.onTimeOut();
                continue;
            }
            if (conn.updateState()) {
                this.getUpdatedRegistrations().add(conn.getRegistration());
                continue;
            }
            if (conn.getInboundWay().getIoState() == IoState.READY) {
                conn.getInboundWay().onSelected();
                continue;
            }
            if (conn.getOutboundWay().getIoState() != IoState.READY) continue;
            conn.getOutboundWay().onSelected();
        }
    }

    protected Selector createSelector() {
        Selector result = null;
        try {
            result = Selector.open();
        }
        catch (IOException ioe) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to open the controller's NIO selector", ioe);
        }
        return result;
    }

    @Override
    protected void doInit() {
        this.selector = this.createSelector();
        this.getHelper().createConnectionPool();
    }

    @Override
    protected void doRelease() {
        try {
            this.getSelector().close();
        }
        catch (IOException e) {
            this.getHelper().getLogger().log(Level.WARNING, "Unable to close the NIO selector", e);
        }
    }

    @Override
    protected void doRun(long sleepTime) throws IOException {
        super.doRun(sleepTime);
        this.registerKeys();
        this.updateKeys();
        this.selectKeys(sleepTime);
        this.controlConnections();
    }

    protected Queue<SelectionRegistration> getNewRegistrations() {
        return this.newRegistrations;
    }

    protected Selector getSelector() {
        return this.selector;
    }

    protected Queue<SelectionRegistration> getUpdatedRegistrations() {
        return this.updatedRegistrations;
    }

    protected void onSelected(SelectionKey selectedKey) throws IOException {
        try {
            if (this.getHelper().getLogger().isLoggable(Level.FINEST)) {
                this.getHelper().getLogger().log(Level.FINEST, "NIO selection detected for key: " + selectedKey);
            }
            if (selectedKey.attachment() != null) {
                ((SelectionRegistration)selectedKey.attachment()).onSelected(selectedKey.readyOps());
            }
        }
        catch (CancelledKeyException cke) {
            this.getHelper().getLogger().log(Level.FINER, "Problem during NIO selection", cke);
            this.getNewRegistrations().add((SelectionRegistration)selectedKey.attachment());
        }
    }

    public SelectionRegistration register(SelectableChannel selectableChannel, int interestOperations, SelectionListener listener) throws IOException {
        SelectionRegistration result = new SelectionRegistration(selectableChannel, interestOperations, listener);
        this.getNewRegistrations().add(result);
        return result;
    }

    protected void registerKeys() {
        SelectionRegistration newRegistration = this.getNewRegistrations().poll();
        while (newRegistration != null) {
            if (this.getHelper().getLogger().isLoggable(Level.FINEST)) {
                this.getHelper().getLogger().log(Level.FINEST, "Registering new NIO interest with selector: " + newRegistration);
            }
            newRegistration.register(this.getSelector());
            newRegistration = this.getNewRegistrations().poll();
        }
    }

    protected void selectKeys(long sleepTime) throws IOException, ClosedByInterruptException {
        int selectCount = this.getSelector().select(sleepTime);
        if (selectCount > 0) {
            if (this.getHelper().getLogger().isLoggable(Level.FINEST)) {
                this.getHelper().getLogger().log(Level.FINEST, "NIO selected " + selectCount + " key(s) !");
            }
            Iterator<SelectionKey> keys = this.getSelector().selectedKeys().iterator();
            while (keys.hasNext()) {
                this.onSelected(keys.next());
                keys.remove();
            }
        } else if (this.getHelper().getLogger().isLoggable(Level.FINEST)) {
            // empty if block
        }
    }

    @Override
    public void shutdown() throws IOException {
        super.shutdown();
        this.getSelector().close();
    }

    protected void updateKeys() throws IOException {
        SelectionRegistration updatedRegistration = this.getUpdatedRegistrations().poll();
        while (updatedRegistration != null) {
            if (this.getHelper().getLogger().isLoggable(Level.FINEST)) {
                this.getHelper().getLogger().log(Level.FINEST, "Updating NIO interest with selector: " + updatedRegistration);
            }
            updatedRegistration.update();
            updatedRegistration = this.getUpdatedRegistrations().poll();
        }
    }
}

