/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.restlet.engine.connector.ConnectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Controller {
    protected final ConnectionHelper<?> helper;
    protected boolean overloaded;
    protected boolean running;

    public Controller(ConnectionHelper<?> helper) {
        this.helper = helper;
        this.overloaded = false;
        this.running = false;
    }

    protected void doInit() {
    }

    protected void doRelease() {
    }

    protected void doRun(long sleepTime) throws IOException {
        this.getHelper().control();
    }

    protected ConnectionHelper<?> getHelper() {
        return this.helper;
    }

    protected ExecutorService getWorkerService() {
        return this.getHelper().getWorkerService();
    }

    public boolean isOverloaded() {
        return this.overloaded;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.doInit();
            this.setRunning(true);
            long sleepTime = this.getHelper().getControllerSleepTimeMs();
            boolean hasWorkerThreads = this.getHelper().hasWorkerThreads();
            while (this.isRunning()) {
                try {
                    if (hasWorkerThreads) {
                        boolean isWorkerServiceOverloaded = this.getHelper().isWorkerServiceOverloaded();
                        if (this.isOverloaded() && !isWorkerServiceOverloaded) {
                            this.setOverloaded(false);
                            this.getHelper().getLogger().info("Connector overload ended. Accepting new work again");
                            this.getHelper().traceWorkerService();
                        } else if (isWorkerServiceOverloaded) {
                            this.setOverloaded(true);
                            this.getHelper().getLogger().info("Connector overload detected. Stop accepting new work");
                            this.getHelper().traceWorkerService();
                        }
                    }
                    this.doRun(sleepTime);
                }
                catch (Throwable ex) {
                    this.helper.getLogger().log(Level.WARNING, "Unexpected error while controlling connector", ex);
                    this.setRunning(false);
                }
            }
        }
        catch (Throwable e) {
            this.helper.getLogger().log(Level.WARNING, "Unexpected error while controlling connector", e);
            this.setRunning(false);
        }
        finally {
            this.doRelease();
        }
    }

    public void setOverloaded(boolean overloaded) {
        this.overloaded = overloaded;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void shutdown() throws IOException {
        this.setRunning(false);
    }
}

