/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.engine.Engine;
import org.restlet.engine.component.ChildContext;
import org.restlet.routing.Filter;
import org.restlet.service.LogService;

public class LogFilter
extends Filter {
    protected volatile LogService logService;
    private volatile Logger logLogger;

    public LogFilter(Context context, LogService logService) {
        super(context);
        this.logService = logService;
        if (logService != null) {
            this.logLogger = logService.getLoggerName() != null ? Engine.getLogger(logService.getLoggerName()) : (context != null && context.getLogger().getParent() != null ? Engine.getLogger(context.getLogger().getParent().getName() + "." + ChildContext.getBestClassName(logService.getClass())) : Engine.getLogger(ChildContext.getBestClassName(logService.getClass())));
        }
    }

    protected void afterHandle(Request request, Response response) {
        if (request.isLoggable() && this.logLogger.isLoggable(Level.INFO)) {
            long startTime = (Long)request.getAttributes().get("org.restlet.startTime");
            int duration = (int)(System.currentTimeMillis() - startTime);
            this.logLogger.log(Level.INFO, this.logService.getResponseLogMessage(response, duration));
        }
    }

    protected int beforeHandle(Request request, Response response) {
        request.getAttributes().put("org.restlet.startTime", System.currentTimeMillis());
        request.setLoggable(this.logService.isLoggable(request));
        if (request.isLoggable() && this.logLogger.isLoggable(Level.FINE)) {
            this.logLogger.fine("Processing request to: \"" + request.getResourceRef().getTargetRef().toString() + "\"");
        }
        return 0;
    }
}

