/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import org.restlet.data.CharacterSet;
import org.restlet.engine.io.IoUtils;

public class ReaderInputStream
extends InputStream {
    private final OutputStreamWriter outputStreamWriter;
    private final PipedInputStream pipedInputStream;
    private final PipedOutputStream pipedOutputStream;
    private final BufferedReader reader;

    public ReaderInputStream(Reader reader, CharacterSet characterSet) throws IOException {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, IoUtils.BUFFER_SIZE);
        this.pipedInputStream = new PipedInputStream();
        this.pipedOutputStream = new PipedOutputStream(this.pipedInputStream);
        this.outputStreamWriter = characterSet != null ? new OutputStreamWriter((OutputStream)this.pipedOutputStream, characterSet.getName()) : new OutputStreamWriter((OutputStream)this.pipedOutputStream, CharacterSet.ISO_8859_1.getName());
    }

    public int available() throws IOException {
        return this.pipedInputStream.available();
    }

    public void close() throws IOException {
        this.reader.close();
        this.outputStreamWriter.close();
        this.pipedInputStream.close();
    }

    public int read() throws IOException {
        int result = -1;
        if (this.pipedInputStream.available() == 0) {
            int character = this.reader.read();
            if (character != -1) {
                this.outputStreamWriter.write(character);
                this.outputStreamWriter.flush();
                this.pipedOutputStream.flush();
                result = this.pipedInputStream.read();
            }
        } else {
            result = this.pipedInputStream.read();
        }
        return result;
    }
}

