/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.engine.connector.ClientOutboundWay;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.HttpClientInboundWay;
import org.restlet.engine.connector.MessageState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientOutboundWay
extends ClientOutboundWay {
    private final Queue<Response> messages = new ConcurrentLinkedQueue<Response>();

    public HttpClientOutboundWay(Connection<?> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    public void clear() {
        super.clear();
        this.messages.clear();
    }

    @Override
    public int getLoadScore() {
        return this.getMessages().size();
    }

    public Queue<Response> getMessages() {
        return this.messages;
    }

    @Override
    protected void handle(Response response) {
        this.getMessages().add(response);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.getMessages().isEmpty();
    }

    @Override
    public void onCompleted(boolean endDetected) {
        Response message = this.getMessage();
        if (message != null) {
            Request request = message.getRequest();
            Queue<Response> inboundMessages = ((HttpClientInboundWay)this.getConnection().getInboundWay()).getMessages();
            this.getMessages().remove(message);
            if (request.isExpectingResponse()) {
                inboundMessages.add(message);
                this.getConnection().getInboundWay().setMessageState(MessageState.START);
            }
        }
        super.onCompleted(endDetected);
    }

    @Override
    public void onError(Status status) {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onOutboundError(status, rsp);
        }
        super.onError(status);
    }

    @Override
    public void updateState() {
        if (!this.getMessages().isEmpty() && this.getMessage() == null) {
            this.setMessage(this.getMessages().peek());
        }
        super.updateState();
    }
}

