/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Uniform;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.io.BufferingRepresentation;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ClientProxy;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Result;
import org.restlet.resource.UniformResource;
import org.restlet.service.ConverterService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResource
extends UniformResource {
    private volatile boolean followingRedirects;
    private volatile int maxRedirects;
    private volatile Uniform next;
    private volatile boolean nextCreated;
    private volatile boolean requestEntityBuffering;
    private volatile boolean responseEntityBuffering;
    private volatile int retryAttempts;
    private volatile long retryDelay;
    private volatile boolean retryOnError;

    public static <T> T create(Context context, Reference reference, Class<? extends T> resourceInterface) {
        ClientResource clientResource = new ClientResource(context, reference);
        return clientResource.wrap(resourceInterface);
    }

    public static <T> T create(Reference reference, Class<? extends T> resourceInterface) {
        return ClientResource.create(null, reference, resourceInterface);
    }

    public static <T> T create(String uri, Class<? extends T> resourceInterface) {
        return ClientResource.create(null, new Reference(uri), resourceInterface);
    }

    protected ClientResource() {
    }

    public ClientResource(ClientResource resource) {
        Request request = new Request(resource.getRequest());
        Response response = new Response(request);
        this.next = resource.getNext();
        this.followingRedirects = resource.isFollowingRedirects();
        this.maxRedirects = resource.getMaxRedirects();
        this.retryOnError = resource.isRetryOnError();
        this.retryDelay = resource.getRetryDelay();
        this.retryAttempts = resource.getRetryAttempts();
        this.requestEntityBuffering = resource.isRequestEntityBuffering();
        this.responseEntityBuffering = resource.isResponseEntityBuffering();
        this.setApplication(resource.getApplication());
        this.init(resource.getContext(), request, response);
    }

    public ClientResource(Context context, URI uri) {
        this(context, Method.GET, uri);
    }

    public ClientResource(Context context, Method method, URI uri) {
        this(context, method, new Reference(uri));
    }

    public ClientResource(Context context, Method method, Reference reference) {
        this(context, new Request(method, reference), new Response(null));
    }

    public ClientResource(Context context, Method method, String uri) {
        this(context, method, new Reference(uri));
    }

    public ClientResource(Context context, Reference reference) {
        this(context, Method.GET, reference);
    }

    public ClientResource(Context context, Request request, Response response) {
        if (context == null) {
            context = Context.getCurrent();
        }
        response.setRequest(request);
        this.followingRedirects = true;
        this.maxRedirects = 10;
        this.retryOnError = true;
        this.retryDelay = 2000L;
        this.retryAttempts = 2;
        this.requestEntityBuffering = false;
        this.responseEntityBuffering = false;
        this.init(context, request, response);
    }

    public ClientResource(Context context, String uri) {
        this(context, Method.GET, uri);
    }

    public ClientResource(URI uri) {
        this(Context.getCurrent(), null, uri);
    }

    public ClientResource(Method method, URI uri) {
        this(Context.getCurrent(), method, uri);
    }

    public ClientResource(Method method, Reference reference) {
        this(Context.getCurrent(), method, reference);
    }

    public ClientResource(Method method, String uri) {
        this(Context.getCurrent(), method, uri);
    }

    public ClientResource(Reference reference) {
        this(Context.getCurrent(), null, reference);
    }

    public ClientResource(Request request, Response response) {
        this(Context.getCurrent(), request, response);
    }

    public ClientResource(String uri) {
        this(Context.getCurrent(), null, uri);
    }

    protected Uniform createNext() {
        Restlet result = null;
        result = this.getApplication().getOutboundRoot();
        if (result == null && this.getContext() != null) {
            result = this.getContext().getClientDispatcher();
        }
        if (result == null) {
            Protocol protocol;
            Protocol rProtocol = this.getProtocol();
            Reference rReference = this.getReference();
            Protocol protocol2 = rProtocol != null ? rProtocol : (protocol = rReference != null ? rReference.getSchemeProtocol() : null);
            if (protocol != null) {
                result = new Client(protocol);
            }
        }
        return result;
    }

    protected Request createRequest(Request prototype) {
        return new Request(prototype);
    }

    protected Response createResponse(Request request) {
        return new Response(request);
    }

    public Representation delete() throws ResourceException {
        return this.handle(Method.DELETE);
    }

    public <T> T delete(Class<T> resultClass) throws ResourceException {
        return this.handle(Method.DELETE, resultClass);
    }

    public Representation delete(MediaType mediaType) throws ResourceException {
        return this.handle(Method.DELETE, mediaType);
    }

    @Override
    protected void doError(Status errorStatus) {
        throw new ResourceException(errorStatus);
    }

    @Override
    protected void doRelease() throws ResourceException {
        if (this.getNext() != null && this.nextCreated) {
            if (this.getNext() instanceof Restlet) {
                try {
                    ((Restlet)this.getNext()).stop();
                }
                catch (Exception e) {
                    throw new ResourceException(e);
                }
            }
            this.setNext(null);
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public Representation get() throws ResourceException {
        return this.handle(Method.GET);
    }

    public <T> T get(Class<T> resultClass) throws ResourceException {
        return this.handle(Method.GET, resultClass);
    }

    public Representation get(MediaType mediaType) throws ResourceException {
        return this.handle(Method.GET, mediaType);
    }

    public ClientResource getChild(Reference relativeRef) throws ResourceException {
        ClientResource result = null;
        if (relativeRef != null && relativeRef.isRelative()) {
            result = new ClientResource(this);
            result.setReference(new Reference(this.getReference().getTargetRef(), relativeRef).getTargetRef());
        } else {
            this.doError(Status.CLIENT_ERROR_BAD_REQUEST, "The child URI is not relative.");
        }
        return result;
    }

    public <T> T getChild(Reference relativeRef, Class<? extends T> resourceInterface) throws ResourceException {
        T result = null;
        ClientResource childResource = this.getChild(relativeRef);
        if (childResource != null) {
            result = childResource.wrap(resourceInterface);
        }
        return result;
    }

    public ClientResource getChild(String relativeUri) throws ResourceException {
        return this.getChild(new Reference(relativeUri));
    }

    public <T> T getChild(String relativeUri, Class<? extends T> resourceInterface) throws ResourceException {
        return this.getChild(new Reference(relativeUri), resourceInterface);
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uniform getNext() {
        Uniform result = this.next;
        if (result == null) {
            ClientResource clientResource = this;
            synchronized (clientResource) {
                if (result == null && (result = this.createNext()) != null) {
                    this.setNext(result);
                    this.nextCreated = true;
                }
            }
        }
        return result;
    }

    public Uniform getOnResponse() {
        return this.getRequest().getOnResponse();
    }

    public Uniform getOnSent() {
        return this.getRequest().getOnSent();
    }

    public ClientResource getParent() throws ResourceException {
        ClientResource result = null;
        if (this.getReference().isHierarchical()) {
            result = new ClientResource(this);
            result.setReference(this.getReference().getParentRef());
        } else {
            this.doError(Status.CLIENT_ERROR_BAD_REQUEST, "The resource URI is not hierarchical.");
        }
        return result;
    }

    public <T> T getParent(Class<? extends T> resourceInterface) throws ResourceException {
        T result = null;
        ClientResource parentResource = this.getParent();
        if (parentResource != null) {
            result = parentResource.wrap(resourceInterface);
        }
        return result;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    @Override
    public Representation handle() {
        Response response = this.handle(new Request(this.getRequest()));
        return response == null ? null : response.getEntity();
    }

    protected Representation handle(Method method) {
        return this.handle(method, (Representation)null);
    }

    protected <T> T handle(Method method, Class<T> resultClass) throws ResourceException {
        return this.handle(method, null, resultClass);
    }

    protected Representation handle(Method method, MediaType mediaType) {
        return this.handle(method, (Representation)null, mediaType);
    }

    protected <T> T handle(Method method, Object entity, Class<T> resultClass) throws ResourceException {
        T result = null;
        ConverterService cs = this.getConverterService();
        List<? extends Variant> variants = cs.getVariants(resultClass, null);
        ClientInfo clientInfo = this.getClientInfo();
        if (clientInfo.getAcceptedMediaTypes().isEmpty()) {
            cs.updatePreferences(clientInfo.getAcceptedMediaTypes(), resultClass);
        }
        result = this.toObject(this.handle(method, entity == null ? null : this.toRepresentation(entity, clientInfo.getPreferredVariant(variants, this.getMetadataService())), clientInfo), resultClass);
        return result;
    }

    protected Representation handle(Method method, Representation entity) {
        return this.handle(method, entity, this.getClientInfo());
    }

    protected Representation handle(Method method, Representation entity, ClientInfo clientInfo) {
        Representation result = null;
        Request request = this.createRequest(this.getRequest());
        request.setMethod(method);
        request.setEntity(entity);
        request.setClientInfo(clientInfo);
        Response response = this.handle(request);
        if (response.getStatus().isError()) {
            this.doError(response.getStatus());
        } else {
            result = response == null ? null : response.getEntity();
        }
        return result;
    }

    protected Representation handle(Method method, Representation entity, MediaType mediaType) {
        return this.handle(method, entity, new ClientInfo(mediaType));
    }

    protected Response handle(Request request) {
        Response response = this.createResponse(request);
        Uniform next = this.getNext();
        if (next != null) {
            this.handle(request, response, null, 0, next);
            this.setResponse(response);
        } else {
            this.getLogger().warning("Unable to process the call for a client resource. No next Restlet has been provided.");
        }
        return response;
    }

    protected void handle(Request request, Response response, List<Reference> references, int retryAttempt, Uniform next) {
        if (next != null) {
            if (this.isRequestEntityBuffering() && request.getEntity() != null && request.getEntity().isTransient() && request.getEntity().isAvailable()) {
                request.setEntity(new BufferingRepresentation(request.getEntity()));
            }
            next.handle(request, response);
            if (this.isFollowingRedirects() && response.getStatus().isRedirection() && response.getLocationRef() != null) {
                boolean doRedirection = false;
                if (request.getMethod().isSafe()) {
                    doRedirection = true;
                } else if (Status.REDIRECTION_SEE_OTHER.equals(response.getStatus())) {
                    request.setMethod(Method.GET);
                    request.setEntity(null);
                    doRedirection = true;
                } else if (Status.REDIRECTION_USE_PROXY.equals(response.getStatus())) {
                    doRedirection = true;
                }
                if (doRedirection) {
                    Reference newTargetRef = response.getLocationRef();
                    if (references != null && references.contains(newTargetRef)) {
                        this.getLogger().warning("Infinite redirection loop detected with URI: " + newTargetRef);
                    } else if (request.getEntity() != null && !request.isEntityAvailable()) {
                        this.getLogger().warning("Unable to follow the redirection because the request entity isn't available anymore.");
                    } else {
                        if (references == null) {
                            references = new ArrayList<Reference>();
                        }
                        if (references.size() >= this.getMaxRedirects()) {
                            this.getLogger().warning("Unable to follow the redirection because the request the maximum number of redirections for a single call has been reached.");
                        } else {
                            references.add(request.getResourceRef());
                            request.setResourceRef(newTargetRef);
                            this.handle(request, response, references, 0, next);
                        }
                    }
                }
            } else if (this.isRetryOnError() && response.getStatus().isRecoverableError() && request.getMethod().isIdempotent() && retryAttempt < this.getRetryAttempts() && (request.getEntity() == null || request.getEntity().isAvailable())) {
                this.getLogger().log(Level.INFO, "A recoverable error was detected (" + response.getStatus().getCode() + "), attempting again in " + this.getRetryDelay() + " ms.");
                if (this.getRetryDelay() > 0L) {
                    try {
                        Thread.sleep(this.getRetryDelay());
                    }
                    catch (InterruptedException e) {
                        this.getLogger().log(Level.FINE, "Retry delay sleep was interrupted", e);
                    }
                }
                this.handle(request, response, references, ++retryAttempt, next);
            }
            if (this.isResponseEntityBuffering() && response.getEntity() != null && response.getEntity().isTransient() && response.getEntity().isAvailable()) {
                response.setEntity(new BufferingRepresentation(response.getEntity()));
            }
        } else {
            this.getLogger().log(Level.WARNING, "Request ignored as no next Restlet is available");
        }
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    public Representation head() throws ResourceException {
        return this.handle(Method.HEAD);
    }

    public Representation head(MediaType mediaType) throws ResourceException {
        return this.handle(Method.HEAD, mediaType);
    }

    public boolean isFollowingRedirects() {
        return this.followingRedirects;
    }

    public boolean isRequestEntityBuffering() {
        return this.requestEntityBuffering;
    }

    public boolean isResponseEntityBuffering() {
        return this.responseEntityBuffering;
    }

    public boolean isRetryOnError() {
        return this.retryOnError;
    }

    public Representation options() throws ResourceException {
        return this.handle(Method.OPTIONS);
    }

    public <T> T options(Class<T> resultClass) throws ResourceException {
        return this.handle(Method.OPTIONS, resultClass);
    }

    public Representation options(MediaType mediaType) throws ResourceException {
        return this.handle(Method.OPTIONS, mediaType);
    }

    public Representation post(Object entity) throws ResourceException {
        return this.post(this.toRepresentation(entity, null));
    }

    public <T> T post(Object entity, Class<T> resultClass) throws ResourceException {
        return this.handle(Method.POST, entity, resultClass);
    }

    public Representation post(Object entity, MediaType mediaType) throws ResourceException {
        return this.handle(Method.POST, this.toRepresentation(entity, null), mediaType);
    }

    public Representation post(Representation entity) throws ResourceException {
        return this.handle(Method.POST, entity);
    }

    public Representation put(Object entity) throws ResourceException {
        return this.put(this.toRepresentation(entity, null));
    }

    public <T> T put(Object entity, Class<T> resultClass) throws ResourceException {
        return this.handle(Method.PUT, entity, resultClass);
    }

    public Representation put(Object entity, MediaType mediaType) throws ResourceException {
        return this.handle(Method.PUT, this.toRepresentation(entity, null), mediaType);
    }

    public Representation put(Representation entity) throws ResourceException {
        return this.handle(Method.PUT, entity);
    }

    public void setChallengeResponse(ChallengeResponse challengeResponse) {
        this.getRequest().setChallengeResponse(challengeResponse);
    }

    public void setChallengeResponse(ChallengeScheme scheme, String identifier, String secret) {
        this.setChallengeResponse(new ChallengeResponse(scheme, identifier, secret));
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.getRequest().setClientInfo(clientInfo);
    }

    public void setConditions(Conditions conditions) {
        this.getRequest().setConditions(conditions);
    }

    public void setCookies(Series<Cookie> cookies) {
        this.getRequest().setCookies(cookies);
    }

    public void setEntityBuffering(boolean entityBuffering) {
        this.setRequestEntityBuffering(entityBuffering);
        this.setResponseEntityBuffering(entityBuffering);
    }

    public void setFollowingRedirects(boolean followingRedirects) {
        this.followingRedirects = followingRedirects;
    }

    public void setHostRef(Reference hostRef) {
        this.getRequest().setHostRef(hostRef);
    }

    public void setHostRef(String hostUri) {
        this.getRequest().setHostRef(hostUri);
    }

    public void setLoggable(boolean loggable) {
        this.getRequest().setLoggable(loggable);
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public void setMethod(Method method) {
        this.getRequest().setMethod(method);
    }

    public void setNext(Uniform next) {
        Restlet nextRestlet;
        if (next instanceof Restlet && (nextRestlet = (Restlet)next).getContext() == null) {
            nextRestlet.setContext(this.getContext());
        }
        this.next = next;
        this.nextCreated = false;
    }

    public void setOnResponse(Uniform onResponseCallback) {
        this.getRequest().setOnResponse(onResponseCallback);
    }

    public void setOnSent(Uniform onSentCallback) {
        this.getRequest().setOnSent(onSentCallback);
    }

    public void setOriginalRef(Reference originalRef) {
        this.getRequest().setOriginalRef(originalRef);
    }

    public void setProtocol(Protocol protocol) {
        this.getRequest().setProtocol(protocol);
    }

    public void setRanges(List<Range> ranges) {
        this.getRequest().setRanges(ranges);
    }

    public void setReference(Reference reference) {
        this.getRequest().setResourceRef(reference);
    }

    public void setReference(String uri) {
        this.getRequest().setResourceRef(uri);
    }

    public void setReferrerRef(Reference referrerRef) {
        this.getRequest().setReferrerRef(referrerRef);
    }

    public void setReferrerRef(String referrerUri) {
        this.getRequest().setReferrerRef(referrerUri);
    }

    public void setRequestEntityBuffering(boolean requestEntityBuffering) {
        this.requestEntityBuffering = requestEntityBuffering;
    }

    public void setResponseEntityBuffering(boolean responseEntityBuffering) {
        this.responseEntityBuffering = responseEntityBuffering;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public void setRetryOnError(boolean retryOnError) {
        this.retryOnError = retryOnError;
    }

    public <T> T wrap(Class<? extends T> resourceInterface) {
        Object result = null;
        final List<AnnotationInfo> annotations = AnnotationUtils.getAnnotations(resourceInterface);
        final ClientResource clientResource = this;
        InvocationHandler h = new InvocationHandler(){

            public Object invoke(Object proxy, java.lang.reflect.Method javaMethod, Object[] args) throws Throwable {
                Object result = null;
                if (javaMethod.equals(Object.class.getMethod("toString", new Class[0]))) {
                    result = "ClientProxy for resource: " + clientResource;
                } else if (javaMethod.equals(ClientProxy.class.getMethod("getClientResource", new Class[0]))) {
                    result = clientResource;
                } else {
                    AnnotationInfo annotation = AnnotationUtils.getAnnotation(annotations, javaMethod);
                    if (annotation != null) {
                        Representation requestEntity = null;
                        boolean isSynchronous = true;
                        if (args != null && args.length > 0) {
                            for (int i = 0; i < args.length; ++i) {
                                Object o = args[i];
                                if (o == null) {
                                    requestEntity = null;
                                    continue;
                                }
                                if (Result.class.isAssignableFrom(o.getClass())) {
                                    isSynchronous = false;
                                    final Result rCallback = (Result)o;
                                    Type[] genericParameterTypes = javaMethod.getGenericParameterTypes();
                                    Type genericParameterType = genericParameterTypes[i];
                                    ParameterizedType parameterizedType = genericParameterType instanceof ParameterizedType ? (ParameterizedType)genericParameterType : null;
                                    final Class actualType = parameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)parameterizedType.getActualTypeArguments()[0] : null;
                                    Uniform callback = new Uniform(){

                                        public void handle(Request request, Response response) {
                                            if (response.getStatus().isError()) {
                                                rCallback.onFailure(new ResourceException(response.getStatus()));
                                            } else if (actualType != null) {
                                                rCallback.onSuccess(ClientResource.this.toObject(response.getEntity(), actualType.getClass()));
                                            } else {
                                                rCallback.onSuccess(null);
                                            }
                                        }
                                    };
                                    ClientResource.this.setOnResponse(callback);
                                    continue;
                                }
                                requestEntity = ClientResource.this.toRepresentation(args[i], null);
                            }
                        }
                        Request request = ClientResource.this.createRequest(ClientResource.this.getRequest());
                        request.setMethod(annotation.getRestletMethod());
                        request.setEntity(requestEntity);
                        List<Variant> responseVariants = annotation.getResponseVariants(ClientResource.this.getMetadataService(), ClientResource.this.getConverterService());
                        if (responseVariants != null) {
                            request.setClientInfo(new ClientInfo(responseVariants));
                        }
                        Response response = ClientResource.this.handle(request);
                        if (isSynchronous) {
                            if (response.getStatus().isError()) {
                                ClientResource.this.doError(response.getStatus());
                            }
                            if (!annotation.getJavaOutputType().equals(Void.TYPE)) {
                                result = ClientResource.this.toObject(response == null ? null : response.getEntity(), annotation.getJavaOutputType());
                            }
                        }
                    }
                }
                return result;
            }
        };
        result = Proxy.newProxyInstance(Engine.getInstance().getClassLoader(), new Class[]{ClientProxy.class, resourceInterface}, h);
        return (T)result;
    }
}

