/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Message;
import org.restlet.Response;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.connector.ConnectionState;
import org.restlet.engine.connector.InboundWay;
import org.restlet.engine.connector.MessageState;
import org.restlet.engine.connector.OutboundWay;
import org.restlet.engine.io.Buffer;
import org.restlet.engine.io.BufferProcessor;
import org.restlet.engine.io.BufferState;
import org.restlet.engine.io.CompletionListener;
import org.restlet.engine.io.IoState;
import org.restlet.util.SelectionListener;
import org.restlet.util.SelectionRegistration;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Way
implements SelectionListener,
CompletionListener,
BufferProcessor {
    private final Buffer buffer;
    private final Connection<?> connection;
    private volatile Series<Parameter> headers;
    private volatile IoState ioState;
    private final StringBuilder lineBuilder;
    private volatile BufferState lineBuilderState;
    private volatile Response message;
    private volatile MessageState messageState;
    private volatile SelectionRegistration registration;

    public Way(Connection<?> connection, int bufferSize) {
        this.connection = connection;
        this.buffer = new Buffer(bufferSize, this.getHelper().isDirectBuffers());
        this.headers = null;
        this.ioState = IoState.IDLE;
        this.lineBuilder = new StringBuilder();
        this.lineBuilderState = BufferState.IDLE;
        this.message = null;
        this.messageState = MessageState.IDLE;
        this.registration = new SelectionRegistration(0, this);
    }

    @Override
    public boolean canLoop(Buffer buffer, Object ... args) {
        return this.getConnection().getState() != ConnectionState.CLOSED && (this.getIoState() == IoState.PROCESSING || this.getIoState() == IoState.READY);
    }

    public void clear() {
        this.buffer.clear();
        this.headers = null;
        this.ioState = IoState.IDLE;
        this.clearLineBuilder();
        this.message = null;
        this.messageState = MessageState.IDLE;
        this.registration.clear();
    }

    protected void clearLineBuilder() {
        this.getLineBuilder().delete(0, this.getLineBuilder().length());
        this.setLineBuilderState(BufferState.IDLE);
    }

    @Override
    public boolean couldDrain(Buffer buffer, Object ... args) {
        return false;
    }

    @Override
    public boolean couldFill(Buffer buffer, Object ... args) {
        return this.getConnection().getState() != ConnectionState.CLOSED;
    }

    protected abstract Message getActualMessage();

    public Buffer getBuffer() {
        return this.buffer;
    }

    protected Connection<?> getConnection() {
        return this.connection;
    }

    protected Series<Parameter> getHeaders() {
        return this.headers;
    }

    protected ConnectionHelper<?> getHelper() {
        return this.getConnection().getHelper();
    }

    protected abstract int getInterestOperations();

    public IoState getIoState() {
        return this.ioState;
    }

    protected StringBuilder getLineBuilder() {
        return this.lineBuilder;
    }

    protected BufferState getLineBuilderState() {
        return this.lineBuilderState;
    }

    public int getLoadScore() {
        return this.getMessage() == null ? 0 : 1;
    }

    protected Logger getLogger() {
        return this.getConnection().getLogger();
    }

    public Response getMessage() {
        return this.message;
    }

    protected MessageState getMessageState() {
        return this.messageState;
    }

    protected SelectionRegistration getRegistration() {
        return this.registration;
    }

    public boolean isAvailable() {
        return this.getMessageState().equals((Object)MessageState.IDLE) && this.getIoState().equals((Object)IoState.IDLE);
    }

    public boolean isEmpty() {
        return this.getBuffer().isEmpty();
    }

    public void onClosed() {
        this.setIoState(IoState.IDLE);
        this.setMessageState(MessageState.IDLE);
        this.setMessage(null);
        this.setHeaders(null);
        this.getBuffer().clear();
    }

    @Override
    public void onCompleted(boolean endDetected) {
        this.setIoState(IoState.IDLE);
        this.setMessageState(MessageState.IDLE);
        this.setMessage(null);
        this.setHeaders(null);
    }

    @Override
    public abstract int onDrain(Buffer var1, int var2, Object ... var3) throws IOException;

    public abstract void onError(Status var1);

    @Override
    public abstract int onFill(Buffer var1, Object ... var2) throws IOException;

    @Override
    public void onSelected() {
        try {
            int drained;
            if (this.getIoState() == IoState.INTEREST) {
                this.setIoState(IoState.PROCESSING);
            } else if (this.getIoState() == IoState.CANCELING) {
                this.setIoState(IoState.CANCELLED);
            }
            if (this.getLogger().isLoggable(Level.FINER)) {
                if (this instanceof InboundWay) {
                    this.getLogger().log(Level.FINER, "Inbound way selected. Processing IO for : " + this);
                } else {
                    this.getLogger().log(Level.FINER, "Outbound way selected. Processing IO for : " + this);
                }
            }
            if ((drained = this.processIoBuffer()) == -1 && this.getConnection().getState() == ConnectionState.CLOSING) {
                this.getBuffer().clear();
            } else if (this.getIoState() == IoState.PROCESSING) {
                this.setIoState(IoState.INTEREST);
            }
        }
        catch (Exception e) {
            this.getConnection().onError("Error while processing a connection", e, Status.CONNECTOR_ERROR_COMMUNICATION);
        }
    }

    protected int processIoBuffer() throws IOException {
        return this.getBuffer().process((BufferProcessor)this, new Object[0]);
    }

    protected void setHeaders(Series<Parameter> headers) {
        this.headers = headers;
    }

    public void setIoState(IoState ioState) {
        if (ioState != this.ioState) {
            if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                if (this instanceof OutboundWay) {
                    Context.getCurrentLogger().log(Level.FINER, "OutboundWay#setIoState: " + (Object)((Object)ioState));
                } else {
                    Context.getCurrentLogger().log(Level.FINER, "InboundWay#setIoState: " + (Object)((Object)ioState));
                }
            }
            this.ioState = ioState;
        }
    }

    protected void setLineBuilderState(BufferState lineBuilderState) {
        this.lineBuilderState = lineBuilderState;
    }

    protected void setMessage(Response message) {
        this.message = message;
    }

    protected void setMessageState(MessageState messageState) {
        if (this.messageState != messageState) {
            this.messageState = messageState;
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().finest("New message state: " + (Object)((Object)messageState));
            }
        }
    }

    protected void setRegistration(SelectionRegistration registration) {
        this.registration = registration;
    }

    public String toString() {
        return (Object)((Object)this.getIoState()) + " | " + (Object)((Object)this.getMessageState()) + " | " + this.getBuffer();
    }

    public void updateState() {
        this.getRegistration().setInterestOperations(this.getInterestOperations());
    }
}

