/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Expectation;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.data.Product;
import org.restlet.engine.Engine;
import org.restlet.engine.header.ProductReader;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.util.ConnegUtils;
import org.restlet.representation.Variant;
import org.restlet.routing.Template;
import org.restlet.routing.Variable;
import org.restlet.security.Role;
import org.restlet.security.User;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientInfo {
    private static volatile List<String> userAgentTemplates = null;
    private volatile List<Preference<CharacterSet>> acceptedCharacterSets;
    private volatile List<Preference<Encoding>> acceptedEncodings;
    private volatile List<Preference<Language>> acceptedLanguages;
    private volatile List<Preference<MediaType>> acceptedMediaTypes;
    private volatile String address;
    private volatile String from;
    private volatile String agent;
    private volatile Map<String, String> agentAttributes;
    private volatile Product agentMainProduct;
    private volatile List<Product> agentProducts;
    private volatile boolean authenticated;
    private volatile List<String> forwardedAddresses;
    private volatile int port;
    private volatile List<Principal> principals;
    private volatile User user;
    private volatile List<Role> roles;
    private volatile List<Expectation> expectations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getUserAgentTemplates() {
        List<String> u = userAgentTemplates;
        if (u != null) return u;
        Class<ClientInfo> clazz = ClientInfo.class;
        synchronized (ClientInfo.class) {
            block9: {
                u = userAgentTemplates;
                if (u != null) return u;
                URL userAgentPropertiesUrl = Engine.getResource("org/restlet/data/agent.properties");
                if (userAgentPropertiesUrl != null) {
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(userAgentPropertiesUrl.openStream(), CharacterSet.UTF_8.getName()), IoUtils.BUFFER_SIZE);
                        String line = reader.readLine();
                        while (line != null) {
                            if (line.trim().length() > 0 && !line.trim().startsWith("#")) {
                                if (u == null) {
                                    u = new CopyOnWriteArrayList<String>();
                                }
                                u.add(line);
                            }
                            line = reader.readLine();
                        }
                        reader.close();
                    }
                    catch (IOException e) {
                        if (Context.getCurrent() == null) break block9;
                        Context.getCurrent().getLogger().warning("Cannot read '" + userAgentPropertiesUrl.toString() + "' due to: " + e.getMessage());
                    }
                }
            }
            userAgentTemplates = u;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return u;
        }
    }

    public ClientInfo() {
        this.address = null;
        this.agent = null;
        this.port = -1;
        this.acceptedCharacterSets = null;
        this.acceptedEncodings = null;
        this.acceptedLanguages = null;
        this.acceptedMediaTypes = null;
        this.forwardedAddresses = null;
        this.from = null;
        this.agentProducts = null;
        this.principals = null;
        this.user = null;
        this.roles = null;
        this.expectations = null;
    }

    public ClientInfo(List<? extends Variant> variants) {
        if (variants != null) {
            for (Variant variant : variants) {
                this.getAcceptedMediaTypes().add(new Preference<MediaType>(variant.getMediaType()));
            }
        }
    }

    public ClientInfo(MediaType mediaType) {
        this.getAcceptedMediaTypes().add(new Preference<MediaType>(mediaType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Preference<CharacterSet>> getAcceptedCharacterSets() {
        List<Preference<CharacterSet>> a = this.acceptedCharacterSets;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.acceptedCharacterSets;
                if (a == null) {
                    this.acceptedCharacterSets = a = new CopyOnWriteArrayList<Preference<CharacterSet>>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Preference<Encoding>> getAcceptedEncodings() {
        List<Preference<Encoding>> a = this.acceptedEncodings;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.acceptedEncodings;
                if (a == null) {
                    this.acceptedEncodings = a = new CopyOnWriteArrayList<Preference<Encoding>>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Preference<Language>> getAcceptedLanguages() {
        List<Preference<Language>> a = this.acceptedLanguages;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.acceptedLanguages;
                if (a == null) {
                    this.acceptedLanguages = a = new CopyOnWriteArrayList<Preference<Language>>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Preference<MediaType>> getAcceptedMediaTypes() {
        List<Preference<MediaType>> a = this.acceptedMediaTypes;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.acceptedMediaTypes;
                if (a == null) {
                    this.acceptedMediaTypes = a = new CopyOnWriteArrayList<Preference<MediaType>>();
                }
            }
        }
        return a;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAgent() {
        return this.agent;
    }

    public Map<String, String> getAgentAttributes() {
        if (this.agentAttributes == null) {
            this.agentAttributes = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
            Template template = null;
            Variable agentName = new Variable(7);
            Variable agentVersion = new Variable(7);
            Variable agentComment = new Variable(4);
            Variable agentCommentAttribute = new Variable(5);
            Variable facultativeData = new Variable(1, null, false, false);
            for (String string : ClientInfo.getUserAgentTemplates()) {
                template = new Template(string, 2);
                template.getVariables().put("agentName", agentName);
                template.getVariables().put("agentVersion", agentVersion);
                template.getVariables().put("agentComment", agentComment);
                template.getVariables().put("agentOs", agentCommentAttribute);
                template.getVariables().put("commentAttribute", agentCommentAttribute);
                template.getVariables().put("facultativeData", facultativeData);
                if (template.parse(this.getAgent(), map) <= -1) continue;
                for (String key : map.keySet()) {
                    this.agentAttributes.put(key, (String)map.get(key));
                }
            }
        }
        return this.agentAttributes;
    }

    public String getAgentName() {
        Product product = this.getMainAgentProduct();
        if (product != null) {
            return product.getName();
        }
        return null;
    }

    public List<Product> getAgentProducts() {
        if (this.agentProducts == null) {
            this.agentProducts = ProductReader.read(this.getAgent());
        }
        return this.agentProducts;
    }

    public String getAgentVersion() {
        Product product = this.getMainAgentProduct();
        if (product != null) {
            return product.getVersion();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Expectation> getExpectations() {
        List<Expectation> a = this.expectations;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.expectations;
                if (a == null) {
                    this.expectations = a = new CopyOnWriteArrayList<Expectation>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getForwardedAddresses() {
        List<String> a = this.forwardedAddresses;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.forwardedAddresses;
                if (a == null) {
                    this.forwardedAddresses = a = new CopyOnWriteArrayList<String>();
                }
            }
        }
        return a;
    }

    public String getFrom() {
        return this.from;
    }

    public Product getMainAgentProduct() {
        if (this.agentMainProduct == null && this.getAgentAttributes() != null) {
            this.agentMainProduct = new Product(this.getAgentAttributes().get("agentName"), this.getAgentAttributes().get("agentVersion"), this.getAgentAttributes().get("agentComment"));
        }
        return this.agentMainProduct;
    }

    public int getPort() {
        return this.port;
    }

    public CharacterSet getPreferredCharacterSet(List<CharacterSet> supported) {
        return ConnegUtils.getPreferredMetadata(supported, this.getAcceptedCharacterSets());
    }

    public Encoding getPreferredEncoding(List<Encoding> supported) {
        return ConnegUtils.getPreferredMetadata(supported, this.getAcceptedEncodings());
    }

    public Language getPreferredLanguage(List<Language> supported) {
        return ConnegUtils.getPreferredMetadata(supported, this.getAcceptedLanguages());
    }

    public MediaType getPreferredMediaType(List<MediaType> supported) {
        return ConnegUtils.getPreferredMetadata(supported, this.getAcceptedMediaTypes());
    }

    public Variant getPreferredVariant(List<? extends Variant> variants, MetadataService metadataService) {
        return ConnegUtils.getPreferredVariant(this, variants, metadataService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Principal> getPrincipals() {
        List<Principal> a = this.principals;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.principals;
                if (a == null) {
                    this.principals = a = new CopyOnWriteArrayList<Principal>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Role> getRoles() {
        List<Role> a = this.roles;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.roles;
                if (a == null) {
                    this.roles = a = new CopyOnWriteArrayList<Role>();
                }
            }
        }
        return a;
    }

    public String getUpstreamAddress() {
        if (this.forwardedAddresses == null || this.forwardedAddresses.isEmpty()) {
            return this.getAddress();
        }
        return this.forwardedAddresses.get(0);
    }

    public User getUser() {
        return this.user;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcceptedCharacterSets(List<Preference<CharacterSet>> acceptedCharacterSets) {
        ClientInfo clientInfo = this;
        synchronized (clientInfo) {
            List<Preference<CharacterSet>> ac = this.getAcceptedCharacterSets();
            ac.clear();
            ac.addAll(acceptedCharacterSets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcceptedEncodings(List<Preference<Encoding>> acceptedEncodings) {
        ClientInfo clientInfo = this;
        synchronized (clientInfo) {
            List<Preference<Encoding>> ac = this.getAcceptedEncodings();
            ac.clear();
            ac.addAll(acceptedEncodings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcceptedLanguages(List<Preference<Language>> acceptedLanguages) {
        ClientInfo clientInfo = this;
        synchronized (clientInfo) {
            List<Preference<Language>> ac = this.getAcceptedLanguages();
            ac.clear();
            ac.addAll(acceptedLanguages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcceptedMediaTypes(List<Preference<MediaType>> acceptedMediaTypes) {
        ClientInfo clientInfo = this;
        synchronized (clientInfo) {
            List<Preference<MediaType>> ac = this.getAcceptedMediaTypes();
            ac.clear();
            ac.addAll(acceptedMediaTypes);
        }
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAgentAttributes(Map<String, String> agentAttributes) {
        ClientInfo clientInfo = this;
        synchronized (clientInfo) {
            Map<String, String> aa = this.getAgentAttributes();
            aa.clear();
            aa.putAll(agentAttributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAgentProducts(List<Product> agentProducts) {
        ClientInfo clientInfo = this;
        synchronized (clientInfo) {
            List<Product> ap = this.getAgentProducts();
            ap.clear();
            ap.addAll(agentProducts);
        }
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpectations(List<Expectation> expectations) {
        ClientInfo clientInfo = this;
        synchronized (clientInfo) {
            List<Expectation> e = this.getExpectations();
            e.clear();
            e.addAll(expectations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForwardedAddresses(List<String> forwardedAddresses) {
        ClientInfo clientInfo = this;
        synchronized (clientInfo) {
            List<String> fa = this.getForwardedAddresses();
            fa.clear();
            fa.addAll(forwardedAddresses);
        }
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setPort(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrincipals(List<Principal> principals) {
        ClientInfo clientInfo = this;
        synchronized (clientInfo) {
            List<Principal> fa = this.getPrincipals();
            fa.clear();
            fa.addAll(principals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoles(List<Role> roles) {
        ClientInfo clientInfo = this;
        synchronized (clientInfo) {
            List<Role> r = this.getRoles();
            r.clear();
            r.addAll(roles);
        }
    }

    public void setUser(User user) {
        this.user = user;
    }
}

