/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.restlet.engine.io.BufferState;
import org.restlet.engine.io.CompletionListener;
import org.restlet.engine.io.NioUtils;
import org.restlet.engine.io.ReadableSelectionChannel;
import org.restlet.engine.io.WrapperSelectionChannel;
import org.restlet.util.SelectionRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadableBufferedChannel
extends WrapperSelectionChannel<ReadableSelectionChannel>
implements ReadableSelectionChannel {
    private volatile BufferState byteBufferState;
    private final CompletionListener completionListener;
    private final ByteBuffer byteBuffer;
    private final StringBuilder lineBuilder;
    private volatile BufferState lineBuilderState;

    public ReadableBufferedChannel(CompletionListener completionListener, ByteBuffer remainingBuffer, ReadableSelectionChannel source) {
        super(source);
        this.setRegistration(new SelectionRegistration(0, null));
        this.completionListener = completionListener;
        this.byteBuffer = remainingBuffer;
        this.byteBufferState = BufferState.DRAINING;
        this.lineBuilder = new StringBuilder();
        this.lineBuilderState = BufferState.IDLE;
    }

    public void clearLineBuilder() {
        this.getLineBuilder().delete(0, this.getLineBuilder().length());
        this.setLineBuilderState(BufferState.IDLE);
    }

    @Override
    public void close() throws IOException {
    }

    public boolean fillLineBuilder() throws IOException {
        boolean result = false;
        if (this.getLineBuilderState() != BufferState.DRAINING) {
            int byteBufferSize = 0;
            if (this.getByteBufferState() == BufferState.DRAINING) {
                byteBufferSize = this.getByteBuffer().remaining();
            }
            if (byteBufferSize == 0) {
                this.setByteBufferState(BufferState.FILLING);
                this.getByteBuffer().clear();
                if (this.refill() > 0) {
                    byteBufferSize = this.getByteBuffer().remaining();
                }
            }
            if (byteBufferSize > 0) {
                this.setLineBuilderState(NioUtils.fillLine(this.getLineBuilder(), this.getLineBuilderState(), this.getByteBuffer()));
                if (this.getByteBuffer().remaining() == 0) {
                    this.setByteBufferState(BufferState.FILLING);
                    this.getByteBuffer().clear();
                }
                return this.getLineBuilderState() == BufferState.DRAINING;
            }
        } else {
            result = true;
        }
        return result;
    }

    protected ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    protected BufferState getByteBufferState() {
        return this.byteBufferState;
    }

    private CompletionListener getCompletionListener() {
        return this.completionListener;
    }

    public StringBuilder getLineBuilder() {
        return this.lineBuilder;
    }

    protected BufferState getLineBuilderState() {
        return this.lineBuilderState;
    }

    public void postRead(int bytesRead) {
        if (bytesRead == -1 && this.getCompletionListener() != null) {
            this.getCompletionListener().onCompleted(bytesRead == -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer targetBuffer) throws IOException {
        int result = 0;
        int currentRead = 0;
        boolean tryAgain = true;
        ByteBuffer byteBuffer = this.getByteBuffer();
        synchronized (byteBuffer) {
            while (tryAgain) {
                switch (this.getByteBufferState()) {
                    case FILLED: {
                        this.setByteBufferState(BufferState.DRAINING);
                    }
                    case DRAINING: {
                        if (this.getByteBuffer().remaining() > 0) {
                            if (this.getByteBuffer().remaining() >= targetBuffer.remaining()) {
                                currentRead = targetBuffer.remaining();
                                tryAgain = false;
                            } else {
                                currentRead = this.getByteBuffer().remaining();
                            }
                            for (int i = 0; i < currentRead; ++i) {
                                targetBuffer.put(this.getByteBuffer().get());
                            }
                            result += currentRead;
                        }
                        if (this.getByteBuffer().remaining() != 0) break;
                        this.setByteBufferState(BufferState.FILLING);
                        this.getByteBuffer().clear();
                        break;
                    }
                    case IDLE: {
                        this.setByteBufferState(BufferState.FILLING);
                    }
                    case FILLING: {
                        int refillCount = this.refill();
                        if (refillCount == -1) {
                            result = -1;
                            tryAgain = false;
                            break;
                        }
                        if (refillCount <= 0) break;
                        tryAgain = true;
                    }
                }
            }
        }
        return result;
    }

    protected int refill() throws IOException {
        int readCount = ((ReadableSelectionChannel)this.getWrappedChannel()).read(this.getByteBuffer());
        if (readCount > 0) {
            this.setByteBufferState(BufferState.DRAINING);
            this.getByteBuffer().flip();
        }
        return readCount;
    }

    protected void setByteBufferState(BufferState bufferState) {
        this.byteBufferState = bufferState;
    }

    protected void setLineBuilderState(BufferState lineBuilderState) {
        this.lineBuilderState = lineBuilderState;
    }
}

