/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Connector
extends Restlet {
    private final List<Protocol> protocols;

    public Connector(Context context) {
        this(context, null);
    }

    public Connector(Context context, List<Protocol> protocols) {
        super(context);
        this.protocols = protocols == null ? new CopyOnWriteArrayList<Protocol>() : new CopyOnWriteArrayList<Protocol>(protocols);
        if (this.protocols.isEmpty()) {
            this.getLogger().fine("The connector has been instantiated without any protocol.");
        }
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public abstract boolean isAvailable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocols(List<Protocol> protocols) {
        List<Protocol> list = this.getProtocols();
        synchronized (list) {
            if (protocols != this.getProtocols()) {
                this.getProtocols().clear();
                if (protocols != null) {
                    this.getProtocols().addAll(protocols);
                }
            }
        }
    }
}

