/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChallengeMessage {
    public static final String QUALITY_AUTHENTICATION = "auth";
    public static final String QUALITY_AUTHENTICATION_INTEGRITY = "auth-int";
    private volatile String rawValue;
    private volatile Series<Parameter> parameters;
    private volatile ChallengeScheme scheme;
    private volatile String serverNonce;
    private volatile String realm;
    private volatile String opaque;
    private volatile String digestAlgorithm;

    public ChallengeMessage(ChallengeScheme scheme) {
        this(scheme, null, null);
    }

    public ChallengeMessage(ChallengeScheme scheme, Series<Parameter> parameters) {
        this(scheme, null, null);
    }

    public ChallengeMessage(ChallengeScheme scheme, String realm) {
        this(scheme, realm, null);
    }

    public ChallengeMessage(ChallengeScheme scheme, String realm, Series<Parameter> parameters) {
        this.scheme = scheme;
        this.rawValue = null;
        this.realm = realm;
        this.parameters = parameters;
        this.digestAlgorithm = "MD5";
        this.serverNonce = null;
        this.opaque = null;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public Series<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new Form();
        }
        return this.parameters;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getRealm() {
        return this.realm;
    }

    public ChallengeScheme getScheme() {
        return this.scheme;
    }

    public String getServerNonce() {
        return this.serverNonce;
    }

    public int hashCode() {
        return SystemUtils.hashCode(this.getScheme(), this.getRealm(), this.getParameters());
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public void setParameters(Series<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setRawValue(String rawValue) {
        this.rawValue = rawValue;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setScheme(ChallengeScheme scheme) {
        this.scheme = scheme;
    }

    public void setServerNonce(String serverNonce) {
        this.serverNonce = serverNonce;
    }
}

