/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Reference;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;
import org.restlet.service.StatusService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniformResource {
    private volatile Context context;
    private volatile Request request;
    private volatile Response response;

    protected void doCatch(Throwable throwable) {
        Level level = Level.INFO;
        Status status = null;
        if (throwable instanceof ResourceException) {
            ResourceException re = (ResourceException)throwable;
            status = re.getStatus();
            if (re.getCause() != null) {
                throwable = re.getCause();
            }
        } else {
            status = this.getStatusService().getStatus(throwable, this);
        }
        if (status.isServerError()) {
            level = Level.WARNING;
        } else if (status.isConnectorError()) {
            level = Level.INFO;
        } else if (status.isClientError()) {
            level = Level.FINE;
        }
        this.getLogger().log(level, "Exception or error caught in resource", throwable);
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status);
        }
    }

    protected void doInit() throws ResourceException {
    }

    protected void doRelease() throws ResourceException {
    }

    public Set<Method> getAllowedMethods() {
        return this.getResponse() == null ? null : this.getResponse().getAllowedMethods();
    }

    public Application getApplication() {
        Application result = Application.getCurrent();
        return result == null ? new Application(this.getContext()) : result;
    }

    public List<ChallengeRequest> getChallengeRequests() {
        return this.getResponse() == null ? null : this.getResponse().getChallengeRequests();
    }

    public ChallengeResponse getChallengeResponse() {
        return this.getRequest() == null ? null : this.getRequest().getChallengeResponse();
    }

    public ClientInfo getClientInfo() {
        return this.getRequest() == null ? null : this.getRequest().getClientInfo();
    }

    public Conditions getConditions() {
        return this.getRequest() == null ? null : this.getRequest().getConditions();
    }

    public Context getContext() {
        return this.context;
    }

    public ConverterService getConverterService() {
        ConverterService result = null;
        result = this.getApplication().getConverterService();
        if (result == null) {
            result = new ConverterService();
        }
        return result;
    }

    public Series<Cookie> getCookies() {
        return this.getRequest() == null ? null : this.getRequest().getCookies();
    }

    public Series<CookieSetting> getCookieSettings() {
        return this.getResponse() == null ? null : this.getResponse().getCookieSettings();
    }

    public Set<Dimension> getDimensions() {
        return this.getResponse() == null ? null : this.getResponse().getDimensions();
    }

    public Reference getHostRef() {
        return this.getRequest() == null ? null : this.getRequest().getHostRef();
    }

    public Reference getLocationRef() {
        return this.getResponse() == null ? null : this.getResponse().getLocationRef();
    }

    public Logger getLogger() {
        return this.getContext() != null ? this.getContext().getLogger() : Context.getCurrentLogger();
    }

    public Form getMatrix() {
        return this.getReference() == null ? null : this.getReference().getMatrixAsForm();
    }

    public int getMaxForwards() {
        return this.getRequest() == null ? null : Integer.valueOf(this.getRequest().getMaxForwards());
    }

    public MetadataService getMetadataService() {
        MetadataService result = null;
        result = this.getApplication().getMetadataService();
        if (result == null) {
            result = new MetadataService();
        }
        return result;
    }

    public Method getMethod() {
        return this.getRequest() == null ? null : this.getRequest().getMethod();
    }

    public Reference getOriginalRef() {
        return this.getRequest() == null ? null : this.getRequest().getOriginalRef();
    }

    public Protocol getProtocol() {
        return this.getRequest() == null ? null : this.getRequest().getProtocol();
    }

    public Form getQuery() {
        return this.getReference() == null ? null : this.getReference().getQueryAsForm();
    }

    public List<Range> getRanges() {
        return this.getRequest() == null ? null : this.getRequest().getRanges();
    }

    public Reference getReference() {
        return this.getRequest() == null ? null : this.getRequest().getResourceRef();
    }

    public Reference getReferrerRef() {
        return this.getRequest() == null ? null : this.getRequest().getReferrerRef();
    }

    public Request getRequest() {
        return this.request;
    }

    public Map<String, Object> getRequestAttributes() {
        return this.getRequest() == null ? null : this.getRequest().getAttributes();
    }

    public Representation getRequestEntity() {
        return this.getRequest() == null ? null : this.getRequest().getEntity();
    }

    public Response getResponse() {
        return this.response;
    }

    public Map<String, Object> getResponseAttributes() {
        return this.getResponse() == null ? null : this.getResponse().getAttributes();
    }

    public Representation getResponseEntity() {
        return this.getResponse() == null ? null : this.getResponse().getEntity();
    }

    public Reference getRootRef() {
        return this.getRequest() == null ? null : this.getRequest().getRootRef();
    }

    public ServerInfo getServerInfo() {
        return this.getResponse() == null ? null : this.getResponse().getServerInfo();
    }

    public Status getStatus() {
        return this.getResponse() == null ? null : this.getResponse().getStatus();
    }

    public StatusService getStatusService() {
        StatusService result = null;
        result = this.getApplication().getStatusService();
        if (result == null) {
            result = new StatusService();
        }
        return result;
    }

    public abstract Representation handle();

    public final void init(Context context, Request request, Response response) {
        this.context = context;
        this.request = request;
        this.response = response;
        try {
            this.doInit();
        }
        catch (Throwable t) {
            this.doCatch(t);
        }
    }

    public boolean isConfidential() {
        return this.getRequest() == null ? null : Boolean.valueOf(this.getRequest().isConfidential());
    }

    public final void release() {
        try {
            this.doRelease();
        }
        catch (Throwable t) {
            this.doCatch(t);
        }
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    protected <T> T toObject(Representation source, Class<T> target) throws ResourceException {
        T result = null;
        if (source != null) {
            try {
                ConverterService cs = this.getConverterService();
                result = cs.toObject(source, target, this);
            }
            catch (Exception e) {
                throw new ResourceException(e);
            }
        }
        return result;
    }

    protected Representation toRepresentation(Object source, Variant target) {
        Representation result = null;
        if (source != null) {
            ConverterService cs = this.getConverterService();
            result = cs.toRepresentation(source, target, this);
        }
        return result;
    }
}

