/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.engine.ClientHelper;
import org.restlet.engine.http.ClientCall;
import org.restlet.engine.http.adapter.ClientAdapter;

public abstract class HttpClientHelper
extends ClientHelper {
    private volatile ClientAdapter adapter = null;

    public HttpClientHelper(Client client) {
        super(client);
    }

    public abstract ClientCall create(Request var1);

    public ClientAdapter getAdapter() throws Exception {
        if (this.adapter == null) {
            String adapterClass = this.getHelpedParameters().getFirstValue("adapter", "org.restlet.engine.http.adapter.ClientAdapter");
            this.adapter = (ClientAdapter)Class.forName(adapterClass).getConstructor(Context.class).newInstance(this.getContext());
        }
        return this.adapter;
    }

    public void handle(Request request, Response response) {
        try {
            ClientCall clientCall = this.getAdapter().toSpecific(this, request);
            this.getAdapter().commit(clientCall, request, response);
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Error while handling an HTTP client call", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e);
        }
    }

    public void setAdapter(ClientAdapter adapter) {
        this.adapter = adapter;
    }
}

