/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.restlet.Connector;
import org.restlet.Message;
import org.restlet.Response;
import org.restlet.data.Parameter;
import org.restlet.engine.ConnectorHelper;
import org.restlet.engine.http.connector.BaseHelper;
import org.restlet.engine.http.connector.ConnectionState;
import org.restlet.engine.http.header.HeaderUtils;
import org.restlet.engine.http.io.ChunkedInputStream;
import org.restlet.engine.http.io.ChunkedOutputStream;
import org.restlet.engine.http.io.ClosingInputStream;
import org.restlet.engine.http.io.InboundStream;
import org.restlet.engine.http.io.InputEntityStream;
import org.restlet.engine.http.io.Notifiable;
import org.restlet.engine.http.io.OutboundStream;
import org.restlet.engine.http.io.SizedInputStream;
import org.restlet.engine.io.TraceInputStream;
import org.restlet.engine.io.TraceOutputStream;
import org.restlet.engine.security.SslUtils;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.ReadableRepresentation;
import org.restlet.representation.Representation;
import org.restlet.service.ConnectorService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Connection<T extends Connector>
implements Notifiable {
    private volatile boolean inboundBusy;
    private volatile boolean outboundBusy;
    private final InputStream inboundStream;
    private final OutputStream outboundStream;
    private volatile boolean persistent;
    private volatile boolean pipelining;
    private volatile ConnectionState state;
    private final Socket socket;
    private final SocketChannel socketChannel;
    private final BaseHelper<T> helper;
    private final Queue<Response> inboundMessages;
    private final Queue<Response> outboundMessages;

    public Connection(BaseHelper<T> helper, Socket socket, SocketChannel socketChannel) throws IOException {
        this.helper = helper;
        this.inboundMessages = new ConcurrentLinkedQueue<Response>();
        this.outboundMessages = new ConcurrentLinkedQueue<Response>();
        this.persistent = helper.isPersistingConnections();
        this.pipelining = helper.isPipeliningConnections();
        this.state = ConnectionState.OPENING;
        this.socket = socket;
        this.socketChannel = socketChannel;
        this.inboundBusy = false;
        this.outboundBusy = false;
        if (this.getHelper().isTracing()) {
            this.inboundStream = new TraceInputStream(new InboundStream(this.getSocket().getInputStream()));
            this.outboundStream = new TraceOutputStream(new OutboundStream(this.getSocket().getOutputStream()));
        } else {
            this.inboundStream = new InboundStream(this.getSocket().getInputStream());
            this.outboundStream = new OutboundStream(this.getSocket().getOutputStream());
        }
    }

    protected void addEntityHeaders(Representation entity, Series<Parameter> headers) {
        HeaderUtils.addEntityHeaders(entity, headers);
    }

    protected void addGeneralHeaders(Message message, Series<Parameter> headers) {
        if (!this.isPersistent()) {
            headers.set("Connection", "close", true);
        }
        if (this.shouldBeChunked(message.getEntity())) {
            headers.add("Transfer-Encoding", "chunked");
        }
        HeaderUtils.addGeneralHeaders(message, headers);
    }

    public boolean canRead() {
        return this.getState() == ConnectionState.OPEN && !this.isInboundBusy();
    }

    public boolean canWrite() {
        return this.getState() == ConnectionState.OPEN && !this.isOutboundBusy() && this.getOutboundMessages().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean graceful) {
        try {
            if (!this.getSocket().isClosed()) {
                this.getSocket().getOutputStream().flush();
                if (!(this.getSocket() instanceof SSLSocket)) {
                    this.getSocket().shutdownInput();
                    this.getSocket().shutdownOutput();
                }
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.FINE, "Unable to properly shutdown socket", ex);
        }
        try {
            if (!this.getSocket().isClosed()) {
                this.getSocket().close();
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.FINE, "Unable to properly close socket", ex);
        }
        finally {
            this.setState(ConnectionState.CLOSED);
        }
    }

    public Representation createInboundEntity(Series<Parameter> headers) {
        Representation result = null;
        long contentLength = HeaderUtils.getContentLength(headers);
        boolean chunkedEncoding = HeaderUtils.isChunkedEncoding(headers);
        boolean connectionClosed = HeaderUtils.isConnectionClose(headers);
        if (contentLength != -1L && contentLength != 0L || chunkedEncoding || connectionClosed) {
            InputStream inboundEntityStream = this.getInboundEntityStream(contentLength, chunkedEncoding);
            ReadableByteChannel inboundEntityChannel = this.getInboundEntityChannel(contentLength, chunkedEncoding);
            if (inboundEntityStream != null) {
                result = new InputRepresentation(inboundEntityStream, null, contentLength){

                    public String getText() throws IOException {
                        try {
                            String string = super.getText();
                            return string;
                        }
                        catch (IOException ioe) {
                            throw ioe;
                        }
                        finally {
                            this.release();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void release() {
                        if (Connection.this.getHelper().isTracing()) {
                            PrintStream printStream = System.out;
                            synchronized (printStream) {
                                System.out.println("\n");
                            }
                        }
                        super.release();
                        Connection.this.setInboundBusy(false);
                    }
                };
            } else if (inboundEntityChannel != null) {
                result = new ReadableRepresentation(inboundEntityChannel, null, contentLength){

                    public void release() {
                        super.release();
                        Connection.this.setInboundBusy(false);
                    }
                };
            }
            result.setSize(contentLength);
        } else {
            result = new EmptyRepresentation();
            this.setInboundBusy(false);
        }
        if (headers != null) {
            try {
                result = HeaderUtils.copyResponseEntityHeaders(headers, result);
            }
            catch (Throwable t) {
                this.getLogger().log(Level.WARNING, "Error while parsing entity headers", t);
            }
        }
        return result;
    }

    public String getAddress() {
        return this.getSocket().getInetAddress() == null ? null : this.getSocket().getInetAddress().getHostAddress();
    }

    public BaseHelper<T> getHelper() {
        return this.helper;
    }

    public ReadableByteChannel getInboundEntityChannel(long size, boolean chunked) {
        return null;
    }

    public InputStream getInboundEntityStream(long size, boolean chunked) {
        InputEntityStream result = null;
        result = chunked ? new ChunkedInputStream(this, this.getInboundStream()) : (size >= 0L ? new SizedInputStream(this, this.getInboundStream(), size) : new ClosingInputStream(this, this.getInboundStream()));
        return result;
    }

    public Queue<Response> getInboundMessages() {
        return this.inboundMessages;
    }

    public InputStream getInboundStream() {
        return this.inboundStream;
    }

    public Logger getLogger() {
        return this.getHelper().getLogger();
    }

    public WritableByteChannel getOutboundEntityChannel(boolean chunked) {
        return null;
    }

    public OutputStream getOutboundEntityStream(boolean chunked) {
        OutputStream result = this.getOutboundStream();
        if (chunked) {
            result = new ChunkedOutputStream(result);
        }
        return result;
    }

    public Queue<Response> getOutboundMessages() {
        return this.outboundMessages;
    }

    public OutputStream getOutboundStream() {
        return this.outboundStream;
    }

    public int getPort() {
        return this.getSocket().getPort();
    }

    protected Representation getRepresentation(InputStream stream) {
        return new InputRepresentation(stream, null);
    }

    protected Representation getRepresentation(ReadableByteChannel channel) {
        return new ReadableRepresentation(channel, null);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public String getSslCipherSuite() {
        SSLSocket sslSocket;
        SSLSession sslSession;
        if (this.getSocket() instanceof SSLSocket && (sslSession = (sslSocket = (SSLSocket)this.getSocket()).getSession()) != null) {
            return sslSession.getCipherSuite();
        }
        return null;
    }

    public List<Certificate> getSslClientCertificates() {
        SSLSocket sslSocket;
        SSLSession sslSession;
        if (this.getSocket() instanceof SSLSocket && (sslSession = (sslSocket = (SSLSocket)this.getSocket()).getSession()) != null) {
            try {
                List<Certificate> clientCertificates = Arrays.asList(sslSession.getPeerCertificates());
                return clientCertificates;
            }
            catch (SSLPeerUnverifiedException e) {
                this.getHelper().getLogger().log(Level.FINE, "Can't get the client certificates.", e);
            }
        }
        return null;
    }

    public Integer getSslKeySize() {
        Integer keySize = null;
        String sslCipherSuite = this.getSslCipherSuite();
        if (sslCipherSuite != null) {
            keySize = SslUtils.extractKeySize(sslCipherSuite);
        }
        return keySize;
    }

    public ConnectionState getState() {
        return this.state;
    }

    public boolean isBusy() {
        return this.isInboundBusy() || this.isOutboundBusy();
    }

    public boolean isClientSide() {
        return this.getHelper().isClientSide();
    }

    public boolean isInboundBusy() {
        return this.inboundBusy;
    }

    public boolean isOutboundBusy() {
        return this.outboundBusy;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isPipelining() {
        return this.pipelining;
    }

    public boolean isServerSide() {
        return this.getHelper().isServerSide();
    }

    @Override
    public void onEndReached() {
        this.setInboundBusy(false);
    }

    @Override
    public void onError() {
        this.setInboundBusy(false);
        this.setState(ConnectionState.CLOSING);
    }

    public void open() {
        try {
            this.setState(ConnectionState.OPEN);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.FINE, "Unable to properly open socket", ex);
        }
    }

    protected abstract void readMessage() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMessages() {
        try {
            boolean doRead = false;
            Connection connection = this;
            synchronized (connection) {
                if (this.canRead()) {
                    doRead = true;
                    this.setInboundBusy(true);
                }
            }
            if (doRead) {
                this.readMessage();
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Error while reading an HTTP message. Closing the connection: ", e.getMessage());
            this.getLogger().log(Level.FINE, "Error while reading an HTTP message. Closing the connection.", e);
            this.close(false);
        }
        this.getHelper().handleNextInbound();
    }

    public void setInboundBusy(boolean inboundBusy) {
        this.inboundBusy = inboundBusy;
    }

    public void setOutboundBusy(boolean outboundBusy) {
        this.outboundBusy = outboundBusy;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setPipelining(boolean pipelining) {
        this.pipelining = pipelining;
    }

    public void setState(ConnectionState state) {
        this.state = state;
    }

    protected boolean shouldBeChunked(Representation entity) {
        return entity != null && entity.getSize() == -1L;
    }

    protected abstract void writeMessage(Response var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMessage(Response message, Series<Parameter> headers) throws IOException {
        if (message != null) {
            ConnectorService connectorService;
            Representation entity;
            Representation representation = entity = this.isClientSide() ? message.getRequest().getEntity() : message.getEntity();
            if (entity != null) {
                Representation representation2 = entity = entity.isAvailable() ? entity : null;
            }
            if ((connectorService = ConnectorHelper.getConnectorService()) != null) {
                connectorService.beforeSend(entity);
            }
            try {
                this.writeMessageHead(message, headers);
                if (entity != null) {
                    boolean chunked = HeaderUtils.isChunkedEncoding(headers);
                    WritableByteChannel entityChannel = this.getOutboundEntityChannel(chunked);
                    OutputStream entityStream = this.getOutboundEntityStream(chunked);
                    this.writeMessageBody(entity, entityChannel, entityStream);
                    if (entityStream != null) {
                        entityStream.flush();
                        entityStream.close();
                    }
                }
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.FINE, "Exception while flushing and closing the entity stream.", ioe);
            }
            finally {
                if (entity != null) {
                    entity.release();
                }
                if (connectorService != null) {
                    connectorService.afterSend(entity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMessageBody(Representation entity, WritableByteChannel entityChannel, OutputStream entityStream) throws IOException {
        if (entityChannel != null) {
            entity.write(entityChannel);
        } else if (entityStream != null) {
            entity.write(entityStream);
            entityStream.flush();
            if (this.getHelper().isTracing()) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println("\n");
                }
            }
        }
    }

    protected void writeMessageHead(Response message, OutputStream headStream, Series<Parameter> headers) throws IOException {
        this.writeMessageHeadLine(message, headStream);
        for (Parameter header : headers) {
            HeaderUtils.writeHeaderLine(header, headStream);
        }
        headStream.write(13);
        headStream.write(10);
        headStream.flush();
    }

    protected void writeMessageHead(Response message, Series<Parameter> headers) throws IOException {
        this.writeMessageHead(message, this.getOutboundStream(), headers);
    }

    protected abstract void writeMessageHeadLine(Response var1, OutputStream var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessages() {
        try {
            Response message = null;
            Connection connection = this;
            synchronized (connection) {
                if (this.canWrite()) {
                    message = this.getOutboundMessages().peek();
                    this.setOutboundBusy(message != null);
                }
            }
            if (message != null) {
                this.writeMessage(message);
                if (this.getState() == ConnectionState.CLOSING && !this.isBusy()) {
                    this.close(true);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error while writing an HTTP message: ", e.getMessage());
            this.getLogger().log(Level.INFO, "Error while writing an HTTP message", e);
        }
    }
}

