/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.connector;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.http.connector.BaseHelper;
import org.restlet.engine.http.connector.Connection;
import org.restlet.engine.http.connector.ConnectionState;
import org.restlet.engine.http.header.HeaderReader;
import org.restlet.engine.http.header.HeaderUtils;
import org.restlet.engine.util.StringUtils;
import org.restlet.util.Series;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConnection
extends Connection<Client> {
    private static String getRequestUri(Reference resourceRef) {
        String result = null;
        Reference absoluteRef = resourceRef.isAbsolute() ? resourceRef : resourceRef.getTargetRef();
        result = absoluteRef.hasQuery() ? absoluteRef.getPath() + "?" + absoluteRef.getQuery() : absoluteRef.getPath();
        if (result == null || result.equals("")) {
            result = "/";
        }
        return result;
    }

    public ClientConnection(BaseHelper<Client> helper, Socket socket, SocketChannel socketChannel) throws IOException {
        super(helper, socket, socketChannel);
    }

    protected void addRequestHeaders(Request request, Series<Parameter> headers) {
        HeaderUtils.addRequestHeaders(request, headers);
    }

    @Override
    public boolean canRead() {
        return super.canRead() && this.getInboundMessages().size() > 0;
    }

    @Override
    public boolean canWrite() {
        return super.canWrite() && (this.getInboundMessages().size() == 0 || this.isPipelining());
    }

    @Override
    protected void readMessage() throws IOException {
        String version = null;
        WrapperList headers = null;
        int statusCode = 0;
        String reasonPhrase = null;
        StringBuilder sb = new StringBuilder();
        int next = this.getInboundStream().read();
        while (next != -1 && !HeaderUtils.isSpace(next)) {
            sb.append((char)next);
            next = this.getInboundStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the response HTTP version. End of stream reached too early.");
        }
        version = sb.toString();
        sb.delete(0, sb.length());
        next = this.getInboundStream().read();
        while (next != -1 && !HeaderUtils.isSpace(next)) {
            sb.append((char)next);
            next = this.getInboundStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the response status. End of stream reached too early.");
        }
        try {
            statusCode = Integer.parseInt(sb.toString());
        }
        catch (NumberFormatException e) {
            throw new IOException("Unable to parse the status code. Non numeric value: " + sb.toString());
        }
        sb.delete(0, sb.length());
        next = this.getInboundStream().read();
        while (next != -1 && !HeaderUtils.isCarriageReturn(next)) {
            sb.append((char)next);
            next = this.getInboundStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the reason phrase. End of stream reached too early.");
        }
        next = this.getInboundStream().read();
        if (HeaderUtils.isLineFeed(next)) {
            reasonPhrase = sb.toString();
            sb.delete(0, sb.length());
            Parameter header = HeaderReader.readHeader(this.getInboundStream(), sb);
            while (header != null) {
                if (headers == null) {
                    headers = new Form();
                }
                headers.add(header);
                header = HeaderReader.readHeader(this.getInboundStream(), sb);
            }
        } else {
            throw new IOException("Unable to parse the reason phrase. The carriage return must be followed by a line feed.");
        }
        if (HeaderUtils.isConnectionClose(headers)) {
            this.setState(ConnectionState.CLOSING);
        }
        Response finalResponse = this.getInboundMessages().peek();
        Response response = null;
        Status status = Status.valueOf(statusCode);
        response = status.isInformational() ? new Response(finalResponse.getRequest()) : finalResponse;
        response.setStatus(status, reasonPhrase);
        response.getServerInfo().setAddress(this.getSocket().getLocalAddress().toString());
        response.getServerInfo().setAgent("Restlet-Framework/2.0rc2");
        response.getServerInfo().setPort(this.getSocket().getPort());
        response.setEntity(this.createInboundEntity((Series<Parameter>)headers));
        try {
            HeaderUtils.copyResponseTransportHeaders((Series<Parameter>)headers, response);
        }
        catch (Throwable t) {
            this.getLogger().log(Level.WARNING, "Error while parsing the headers", t);
        }
        if (headers != null) {
            response.getAttributes().put("org.restlet.http.headers", headers);
        }
        if (!response.getStatus().isInformational()) {
            this.getInboundMessages().poll();
        }
        this.getHelper().getInboundMessages().add(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeMessage(Response response) {
        Form headers = new Form();
        Request request = response.getRequest();
        try {
            this.addGeneralHeaders(request, headers);
            this.addRequestHeaders(request, headers);
            this.addEntityHeaders(request.getEntity(), headers);
            this.writeMessage(response, headers);
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "An exception occured writing the request", e);
            response.setStatus(Status.CONNECTOR_ERROR_COMMUNICATION, "An exception occured writing the request");
            response.setEntity(null);
            try {
                this.writeMessage(response, headers);
            }
            catch (Exception ee) {
                this.getLogger().log(Level.WARNING, "Unable to send error request", ee);
            }
        }
        finally {
            if (request.getOnSent() != null) {
                request.getOnSent().handle(request, response);
            }
            this.getOutboundMessages().poll();
            if (request.isExpectingResponse()) {
                this.getInboundMessages().add(response);
            }
            this.setOutboundBusy(false);
        }
    }

    @Override
    protected void writeMessageHeadLine(Response message, OutputStream headStream) throws IOException {
        Request request = message.getRequest();
        headStream.write(StringUtils.getAsciiBytes(request.getMethod().getName()));
        headStream.write(32);
        headStream.write(StringUtils.getAsciiBytes(ClientConnection.getRequestUri(request.getResourceRef())));
        headStream.write(32);
        headStream.write(StringUtils.getAsciiBytes(request.getProtocol().getName()));
        headStream.write(47);
        headStream.write(StringUtils.getAsciiBytes(request.getProtocol().getVersion()));
        HeaderUtils.writeCRLF(this.getOutboundStream());
    }
}

