/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.restlet.engine.Edition;
import org.restlet.engine.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineClassLoader
extends ClassLoader {
    public EngineClassLoader() {
        super(EngineClassLoader.class.getClassLoader());
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        ClassLoader cl = Engine.getUserClassLoader();
        if (cl != null) {
            try {
                result = cl.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (result == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                result = cl.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                result = Class.forName(name);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    @Override
    protected URL findResource(String name) {
        URL result = null;
        ClassLoader cl = Engine.getUserClassLoader();
        if (cl != null) {
            result = cl.getResource(name);
        }
        if (result == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            result = cl.getResource(name);
        }
        return result;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> result = null;
        ClassLoader cl = Engine.getUserClassLoader();
        if (cl != null) {
            result = cl.getResources(name);
        }
        if (result == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            result = cl.getResources(name);
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> result;
        block4: {
            Enumeration<URL> allUrls = super.getResources(name);
            result = new Vector<URL>();
            if (allUrls != null) {
                try {
                    while (allUrls.hasMoreElements()) {
                        URL url = allUrls.nextElement();
                        if (result.indexOf(url) != -1) continue;
                        result.add(url);
                    }
                }
                catch (NullPointerException e) {
                    if (Edition.CURRENT == Edition.ANDROID) break block4;
                    throw e;
                }
            }
        }
        return result.elements();
    }
}

