/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.header;

import java.io.IOException;
import org.restlet.data.Disposition;
import org.restlet.data.Parameter;
import org.restlet.engine.http.header.HeaderUtils;

public class DispositionUtils {
    public static String format(Disposition disposition) {
        if ("none".equals(disposition.getType()) || disposition.getType() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(disposition.getType());
        for (Parameter parameter : disposition.getParameters()) {
            sb.append("; ");
            sb.append(parameter.getName());
            sb.append("=");
            if (HeaderUtils.isToken(parameter.getValue())) {
                sb.append(parameter.getValue());
                continue;
            }
            try {
                HeaderUtils.appendQuote(parameter.getValue(), sb);
            }
            catch (IOException e) {}
        }
        return sb.toString();
    }

    private DispositionUtils() {
    }
}

