/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.routing.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
extends Filter {
    private volatile List<ValidateInfo> validations;

    public Validator() {
        this(null);
    }

    public Validator(Context context) {
        this(context, null);
    }

    public Validator(Context context, Restlet next) {
        super(context, next);
    }

    @Override
    protected int beforeHandle(Request request, Response response) {
        if (this.validations != null) {
            for (ValidateInfo validate : this.getValidations()) {
                if (validate.required && !request.getAttributes().containsKey(validate.attribute)) {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to find the \"" + validate.attribute + "\" attribute in the request. Please check your request.");
                    continue;
                }
                if (validate.format == null) continue;
                Object value = request.getAttributes().get(validate.attribute);
                if (value == null) {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to validate the \"" + validate.attribute + "\" attribute with a null value. Please check your request.");
                    continue;
                }
                if (Pattern.matches(validate.format, value.toString())) continue;
                response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to validate the value of the \"" + validate.attribute + "\" attribute. The expected format is: " + validate.format + " (Java Regex). Please check your request.");
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValidateInfo> getValidations() {
        List<ValidateInfo> v = this.validations;
        if (v == null) {
            Validator validator = this;
            synchronized (validator) {
                v = this.validations;
                if (v == null) {
                    this.validations = v = new CopyOnWriteArrayList<ValidateInfo>();
                }
            }
        }
        return v;
    }

    protected void validate(String attribute, boolean required, String format) {
        this.getValidations().add(new ValidateInfo(attribute, required, format));
    }

    private static final class ValidateInfo {
        protected String attribute;
        protected String format;
        protected boolean required;

        public ValidateInfo(String attribute, boolean required, String format) {
            this.attribute = attribute;
            this.required = required;
            this.format = format;
        }
    }
}

