/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.util.Date;
import org.restlet.Request;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.DateUtils;
import org.restlet.engine.util.DigestUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMsSharedKeyLiteHelper
extends AuthenticatorHelper {
    private static String getCanonicalizedResourceName(Reference resourceRef) {
        Form form = resourceRef.getQueryAsForm();
        Object param = form.getFirst("comp", true);
        if (param != null) {
            StringBuilder sb = new StringBuilder(resourceRef.getPath());
            return sb.append("?").append("comp=").append(((Parameter)param).getValue()).toString();
        }
        return resourceRef.getPath();
    }

    public HttpMsSharedKeyLiteHelper() {
        super(ChallengeScheme.HTTP_MS_SHAREDKEY_LITE, true, false);
    }

    @Override
    public String format(ChallengeRequest request) {
        return null;
    }

    @Override
    public void formatCredentials(StringBuilder sb, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        String date = "";
        if (httpHeaders.getFirstValue("x-ms-date", true) == null) {
            date = httpHeaders.getFirstValue("Date", true);
            if (date == null) {
                date = DateUtils.format(new Date(), DateUtils.FORMAT_RFC_1123.get(0));
                httpHeaders.add("Date", date);
            }
        } else {
            date = httpHeaders.getFirstValue("x-ms-date", true);
        }
        String canonicalizedResource = HttpMsSharedKeyLiteHelper.getCanonicalizedResourceName(request.getResourceRef());
        StringBuilder rest = new StringBuilder();
        rest.append(date).append('\n').append('/').append(challenge.getIdentifier()).append(canonicalizedResource);
        sb.append(challenge.getIdentifier()).append(':').append(Base64.encode(DigestUtils.toHMac256(rest.toString(), Base64.decode(challenge.getSecret())), true));
    }
}

