/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Dimension;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.http.CookieReader;
import org.restlet.engine.http.CookieUtils;
import org.restlet.engine.http.HeaderReader;
import org.restlet.engine.http.HttpAdapter;
import org.restlet.engine.http.HttpClientCall;
import org.restlet.engine.http.HttpClientHelper;
import org.restlet.engine.http.PreferenceUtils;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.DateUtils;
import org.restlet.engine.util.RangeUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientAdapter
extends HttpAdapter {
    public static void copyResponseTransportHeaders(Iterable<Parameter> headers, Response response) {
        for (Parameter header : headers) {
            String value;
            HeaderReader hr;
            ChallengeRequest request;
            if (header.getName().equalsIgnoreCase("Location")) {
                response.setLocationRef(header.getValue());
                continue;
            }
            if (header.getName().equalsIgnoreCase("Set-Cookie") || header.getName().equalsIgnoreCase("Set-Cookie2")) {
                try {
                    CookieReader cr = new CookieReader(header.getValue());
                    response.getCookieSettings().add(cr.readCookieSetting());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Error during cookie setting parsing. Header: " + header.getValue(), e);
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("WWW-Authenticate")) {
                request = AuthenticatorUtils.parseAuthenticateHeader(header.getValue());
                response.getChallengeRequests().add(request);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Proxy-Authenticate")) {
                request = AuthenticatorUtils.parseAuthenticateHeader(header.getValue());
                response.getProxyChallengeRequests().add(request);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Server")) {
                response.getServerInfo().setAgent(header.getValue());
                continue;
            }
            if (header.getName().equalsIgnoreCase("Allow")) {
                hr = new HeaderReader(header.getValue());
                value = hr.readValue();
                Set<Method> allowedMethods = response.getAllowedMethods();
                while (value != null) {
                    allowedMethods.add(Method.valueOf(value));
                    value = hr.readValue();
                }
                continue;
            }
            if (!header.getName().equalsIgnoreCase("Vary")) continue;
            hr = new HeaderReader(header.getValue());
            value = hr.readValue();
            Set<Dimension> dimensions = response.getDimensions();
            while (value != null) {
                if (value.equalsIgnoreCase("Accept")) {
                    dimensions.add(Dimension.MEDIA_TYPE);
                } else if (value.equalsIgnoreCase("Accept-Charset")) {
                    dimensions.add(Dimension.CHARACTER_SET);
                } else if (value.equalsIgnoreCase("Accept-Encoding")) {
                    dimensions.add(Dimension.ENCODING);
                } else if (value.equalsIgnoreCase("Accept-Language")) {
                    dimensions.add(Dimension.LANGUAGE);
                } else if (value.equalsIgnoreCase("Authorization")) {
                    dimensions.add(Dimension.AUTHORIZATION);
                } else if (value.equalsIgnoreCase("User-Agent")) {
                    dimensions.add(Dimension.CLIENT_AGENT);
                } else if (value.equals("*")) {
                    dimensions.add(Dimension.UNSPECIFIED);
                }
                value = hr.readValue();
            }
        }
    }

    public HttpClientAdapter(Context context) {
        super(context);
    }

    protected void addRequestHeaders(HttpClientCall httpCall, Request request) {
        if (httpCall != null) {
            ChallengeResponse proxyChallengeResponse;
            ClientInfo client;
            int i;
            Reference hostRef;
            Series<Parameter> requestHeaders = httpCall.getRequestHeaders();
            Reference reference = hostRef = request.getResourceRef().getBaseRef() != null ? request.getResourceRef().getBaseRef() : request.getResourceRef();
            if (hostRef.getHostDomain() != null) {
                String host = hostRef.getHostDomain();
                int hostRefPortValue = hostRef.getHostPort();
                if (hostRefPortValue != -1 && hostRefPortValue != request.getProtocol().getDefaultPort()) {
                    host = host + ':' + hostRefPortValue;
                }
                requestHeaders.add("Host", host);
            }
            if (request.getClientInfo().getAgent() != null) {
                requestHeaders.add("User-Agent", request.getClientInfo().getAgent());
            } else {
                requestHeaders.add("User-Agent", "Restlet-Framework/2.0m5");
            }
            Conditions condition = request.getConditions();
            if (!condition.getMatch().isEmpty()) {
                StringBuilder value = new StringBuilder();
                for (i = 0; i < condition.getMatch().size(); ++i) {
                    if (i > 0) {
                        value.append(", ");
                    }
                    value.append(condition.getMatch().get(i).format());
                }
                httpCall.getRequestHeaders().add("If-Match", value.toString());
            }
            if (condition.getModifiedSince() != null) {
                String imsDate = DateUtils.format(condition.getModifiedSince());
                requestHeaders.add("If-Modified-Since", imsDate);
            }
            if (!condition.getNoneMatch().isEmpty()) {
                StringBuilder value = new StringBuilder();
                for (i = 0; i < condition.getNoneMatch().size(); ++i) {
                    if (i > 0) {
                        value.append(", ");
                    }
                    value.append(condition.getNoneMatch().get(i).format());
                }
                requestHeaders.add("If-None-Match", value.toString());
            }
            if (condition.getUnmodifiedSince() != null) {
                String iusDate = DateUtils.format(condition.getUnmodifiedSince(), DateUtils.FORMAT_RFC_1123.get(0));
                requestHeaders.add("If-Unmodified-Since", iusDate);
            }
            if (request.getCookies().size() > 0) {
                String cookies = CookieUtils.format(request.getCookies());
                requestHeaders.add("Cookie", cookies);
            }
            if (request.getReferrerRef() != null) {
                requestHeaders.add("Referer", request.getReferrerRef().toString());
            }
            if ((client = request.getClientInfo()).getAcceptedMediaTypes().size() > 0) {
                try {
                    requestHeaders.add("Accept", PreferenceUtils.format(client.getAcceptedMediaTypes()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            } else {
                requestHeaders.add("Accept", MediaType.ALL.getName());
            }
            if (client.getAcceptedCharacterSets().size() > 0) {
                try {
                    requestHeaders.add("Accept-Charset", PreferenceUtils.format(client.getAcceptedCharacterSets()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            }
            if (client.getAcceptedEncodings().size() > 0) {
                try {
                    requestHeaders.add("Accept-Encoding", PreferenceUtils.format(client.getAcceptedEncodings()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            }
            if (client.getAcceptedLanguages().size() > 0) {
                try {
                    requestHeaders.add("Accept-Language", PreferenceUtils.format(client.getAcceptedLanguages()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            }
            if (!request.getRanges().isEmpty()) {
                requestHeaders.add("Range", RangeUtils.formatRanges(request.getRanges()));
            }
            if (request.isEntityAvailable()) {
                int i2;
                if (request.getEntity().getMediaType() != null) {
                    String contentType = request.getEntity().getMediaType().toString();
                    if (request.getEntity().getMediaType().getParameters().getFirstValue("charset") == null && request.getEntity().getCharacterSet() != null) {
                        contentType = contentType + "; charset=" + request.getEntity().getCharacterSet().getName();
                    }
                    requestHeaders.add("Content-Type", contentType);
                }
                if (!request.getEntity().getEncodings().isEmpty()) {
                    StringBuilder value = new StringBuilder();
                    for (i2 = 0; i2 < request.getEntity().getEncodings().size(); ++i2) {
                        if (i2 > 0) {
                            value.append(", ");
                        }
                        value.append(request.getEntity().getEncodings().get(i2).getName());
                    }
                    requestHeaders.add("Content-Encoding", value.toString());
                }
                if (!request.getEntity().getLanguages().isEmpty()) {
                    StringBuilder value = new StringBuilder();
                    for (i2 = 0; i2 < request.getEntity().getLanguages().size(); ++i2) {
                        if (i2 > 0) {
                            value.append(", ");
                        }
                        value.append(request.getEntity().getLanguages().get(i2).getName());
                    }
                    requestHeaders.add("Content-Language", value.toString());
                }
                if (request.getEntity().getSize() > 0L) {
                    requestHeaders.add("Content-Length", String.valueOf(request.getEntity().getSize()));
                }
                if (request.getEntity().getRange() != null) {
                    try {
                        requestHeaders.add("Content-Range", RangeUtils.formatContentRange(request.getEntity().getRange(), request.getEntity().getSize()));
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.WARNING, "Unable to format the HTTP Content-Range header", e);
                    }
                }
                if (request.getEntity().getDigest() != null && "MD5".equals(request.getEntity().getDigest().getAlgorithm())) {
                    requestHeaders.add("Content-MD5", Base64.encode(request.getEntity().getDigest().getValue(), false));
                }
            }
            Series additionalHeaders = (Series)request.getAttributes().get("org.restlet.http.headers");
            this.addAdditionalHeaders(requestHeaders, additionalHeaders);
            ChallengeResponse challengeResponse = request.getChallengeResponse();
            if (challengeResponse != null) {
                requestHeaders.add("Authorization", AuthenticatorUtils.format(challengeResponse, request, requestHeaders));
            }
            if ((proxyChallengeResponse = request.getProxyChallengeResponse()) != null) {
                requestHeaders.add("Proxy-Authorization", AuthenticatorUtils.format(proxyChallengeResponse, request, requestHeaders));
            }
        }
    }

    public void updateResponse(Response response, Status status, HttpClientCall httpCall) {
        response.setStatus(status);
        response.getServerInfo().setAddress(httpCall.getServerAddress());
        response.getServerInfo().setPort(httpCall.getServerPort());
        this.readResponseHeaders(httpCall, response);
        response.setEntity(httpCall.getResponseEntity(response));
        if (response.getEntity() != null) {
            if (response.getEntity().getSize() == 0L) {
                response.getEntity().release();
            } else if (response.getRequest().getMethod().equals(Method.HEAD)) {
                response.getEntity().release();
            } else if (response.getStatus().equals(Status.SUCCESS_NO_CONTENT)) {
                response.getEntity().release();
            } else if (response.getStatus().equals(Status.SUCCESS_RESET_CONTENT)) {
                response.getEntity().release();
                response.setEntity(null);
            } else if (response.getStatus().equals(Status.REDIRECTION_NOT_MODIFIED)) {
                response.getEntity().release();
            } else if (response.getStatus().isInformational()) {
                response.getEntity().release();
                response.setEntity(null);
            }
        }
    }

    public void commit(HttpClientCall httpCall, Request request, Response response) {
        if (httpCall != null) {
            this.updateResponse(response, httpCall.sendRequest(request), httpCall);
        }
    }

    protected void readResponseHeaders(HttpClientCall httpCall, Response response) {
        try {
            Series<Parameter> responseHeaders = httpCall.getResponseHeaders();
            response.getAttributes().put("org.restlet.http.headers", responseHeaders);
            HttpClientAdapter.copyResponseTransportHeaders(responseHeaders, response);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "An error occured during the processing of the HTTP response.", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e);
        }
    }

    public HttpClientCall toSpecific(HttpClientHelper client, Request request) {
        HttpClientCall result = client.create(request);
        this.addRequestHeaders(result, request);
        return result;
    }
}

