/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.data.Response;
import org.restlet.routing.VirtualHost;
import org.restlet.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskService
extends Service
implements ExecutorService {
    private volatile boolean shutdownAllowed = false;
    private volatile ExecutorService wrapped;

    public static ExecutorService wrap(final ExecutorService executorService) {
        return new AbstractExecutorService(){

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                return executorService.awaitTermination(timeout, unit);
            }

            @Override
            public void execute(final Runnable runnable) {
                final Application currentApplication = Application.getCurrent();
                final Context currentContext = Context.getCurrent();
                final Integer currentVirtualHost = VirtualHost.getCurrent();
                final Response currentResponse = Response.getCurrent();
                executorService.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Response.setCurrent(currentResponse);
                        Context.setCurrent(currentContext);
                        VirtualHost.setCurrent(currentVirtualHost);
                        Application.setCurrent(currentApplication);
                        try {
                            runnable.run();
                        }
                        finally {
                            Response.setCurrent(null);
                            Context.setCurrent(null);
                            VirtualHost.setCurrent(-1);
                            Application.setCurrent(null);
                        }
                    }
                });
            }

            @Override
            public boolean isShutdown() {
                return executorService.isShutdown();
            }

            @Override
            public boolean isTerminated() {
                return executorService.isTerminated();
            }

            @Override
            public void shutdown() {
                executorService.shutdown();
            }

            @Override
            public List<Runnable> shutdownNow() {
                return executorService.shutdownNow();
            }
        };
    }

    public TaskService() {
        this.setWrapped(TaskService.wrap(this.createExecutorService()));
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.getWrapped().awaitTermination(timeout, unit);
    }

    protected ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool(this.createThreadFactory());
    }

    protected ThreadFactory createThreadFactory() {
        return new RestletThreadFactory();
    }

    @Override
    public void execute(Runnable command) {
        this.getWrapped().execute(command);
    }

    private ExecutorService getWrapped() {
        return this.wrapped;
    }

    public List invokeAll(Collection tasks) throws InterruptedException {
        return this.getWrapped().invokeAll(tasks);
    }

    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getWrapped().invokeAll(tasks, timeout, unit);
    }

    public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        return this.getWrapped().invokeAny(tasks);
    }

    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getWrapped().invokeAny(tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.getWrapped().isShutdown();
    }

    public boolean isShutdownAllowed() {
        return this.shutdownAllowed;
    }

    @Override
    public boolean isTerminated() {
        return this.getWrapped().isTerminated();
    }

    public void setShutdownAllowed(boolean allowShutdown) {
        this.shutdownAllowed = allowShutdown;
    }

    private void setWrapped(ExecutorService wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void shutdown() {
        if (this.isShutdownAllowed()) {
            this.getWrapped().shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.isShutdownAllowed() ? this.getWrapped().shutdownNow() : Collections.emptyList();
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.getWrapped().isShutdown()) {
            this.setWrapped(TaskService.wrap(this.createExecutorService()));
        }
        super.start();
    }

    @Override
    public synchronized void stop() throws Exception {
        super.stop();
        if (!this.getWrapped().isShutdown()) {
            this.getWrapped().shutdown();
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.getWrapped().submit(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.getWrapped().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.getWrapped().submit(task, result);
    }

    private static class RestletThreadFactory
    implements ThreadFactory {
        final ThreadFactory factory = Executors.defaultThreadFactory();

        private RestletThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread t = this.factory.newThread(runnable);
            t.setName(t.getName().replaceFirst("pool", "restlet"));
            return t;
        }
    }
}

