/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.security.Permission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Role {
    public static final Role ALL = new Role("*", "Role that covers all existing roles."){

        public void setDescription(String description) {
            throw new IllegalStateException("Unmodifiable role");
        }

        public void setName(String name) {
            throw new IllegalStateException("Unmodifiable role");
        }
    };
    private List<Role> childRoles;
    private List<Permission> deniedPermissions;
    private volatile String description;
    private List<Permission> grantedPermissions;
    private boolean inheritPermissions;
    private volatile String name;

    public Role() {
        this(null, null);
    }

    public Role(String name, String description) {
        this.name = name;
        this.description = description;
        this.childRoles = new CopyOnWriteArrayList<Role>();
    }

    public List<Role> getChildRoles() {
        return this.childRoles;
    }

    public List<Permission> getDeniedPermissions() {
        return this.deniedPermissions;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Permission> getGrantedPermissions() {
        return this.grantedPermissions;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInheritPermissions() {
        return this.inheritPermissions;
    }

    public void setChildRoles(List<Role> children) {
        this.childRoles.clear();
        if (children != null) {
            this.childRoles.addAll(children);
        }
    }

    public void setDeniedPermissions(List<Permission> deniedPermissions) {
        this.deniedPermissions = deniedPermissions;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGrantedPermissions(List<Permission> grantedPermissions) {
        this.grantedPermissions = grantedPermissions;
    }

    public void setInheritPermissions(boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }
}

