/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.restlet.engine.io.SelectorFactory;

public class NioUtils {
    public static final int NIO_TIMEOUT = 60000;

    public static void release(Selector selector, SelectionKey selectionKey) throws IOException {
        if (selectionKey != null) {
            selectionKey.cancel();
            if (selector != null) {
                selector.selectNow();
                SelectorFactory.returnSelector(selector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForState(SelectableChannel selectableChannel, int operations) throws IOException {
        if (selectableChannel != null) {
            Selector selector = null;
            SelectionKey selectionKey = null;
            int selected = 0;
            try {
                selector = SelectorFactory.getSelector();
                while (selected == 0) {
                    selectionKey = selectableChannel.register(selector, operations);
                    selected = selector.select(60000L);
                }
            }
            finally {
                NioUtils.release(selector, selectionKey);
            }
        }
    }

    private NioUtils() {
    }
}

