/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.converter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.ObjectRepresentation;
import org.restlet.representation.ReaderRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_ALL = new VariantInfo(MediaType.ALL);
    private static final VariantInfo VARIANT_FORM = new VariantInfo(MediaType.APPLICATION_WWW_FORM);
    private static final VariantInfo VARIANT_OBJECT = new VariantInfo(MediaType.APPLICATION_JAVA_OBJECT);
    private static final VariantInfo VARIANT_OBJECT_XML = new VariantInfo(MediaType.APPLICATION_JAVA_OBJECT_XML);
    private static final VariantInfo VARIANT_TEXT = new VariantInfo(MediaType.TEXT_PLAIN);

    @Override
    public List<Class<?>> getObjectClasses(Variant source) {
        List<Class<?>> result = null;
        result = this.addObjectClass(result, String.class);
        result = this.addObjectClass(result, InputStream.class);
        result = this.addObjectClass(result, Reader.class);
        result = this.addObjectClass(result, ReadableByteChannel.class);
        if (source.getMediaType() != null) {
            MediaType mediaType = source.getMediaType();
            if (MediaType.APPLICATION_JAVA_OBJECT.equals(mediaType) || MediaType.APPLICATION_JAVA_OBJECT_XML.equals(mediaType)) {
                result = this.addObjectClass(result, Object.class);
            } else if (MediaType.APPLICATION_WWW_FORM.equals(mediaType)) {
                result = this.addObjectClass(result, Form.class);
            }
        }
        return result;
    }

    @Override
    public List<VariantInfo> getVariants(Class<?> source) {
        List<VariantInfo> result = null;
        if (String.class.isAssignableFrom(source) || StringRepresentation.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_TEXT);
        } else if (File.class.isAssignableFrom(source) || FileRepresentation.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_ALL);
        } else if (InputStream.class.isAssignableFrom(source) || InputRepresentation.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_ALL);
        } else if (Reader.class.isAssignableFrom(source) || ReaderRepresentation.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_TEXT);
        } else if (Representation.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_ALL);
        } else if (Form.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_FORM);
        } else if (Serializable.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_OBJECT);
            result = this.addVariant(result, VARIANT_OBJECT_XML);
        }
        return result;
    }

    @Override
    public float score(Object source, Variant target, UniformResource resource) {
        float result = -1.0f;
        if (source instanceof String) {
            result = 1.0f;
        } else if (source instanceof File) {
            result = 1.0f;
        } else if (source instanceof Form) {
            result = target != null && MediaType.APPLICATION_WWW_FORM.isCompatible(target.getMediaType()) ? 1.0f : 0.5f;
        } else if (source instanceof InputStream) {
            result = 1.0f;
        } else if (source instanceof Reader) {
            result = 1.0f;
        } else if (source instanceof Representation) {
            result = 1.0f;
        } else if (source instanceof Serializable) {
            if (target != null) {
                if (MediaType.APPLICATION_JAVA_OBJECT.equals(target.getMediaType())) {
                    result = 1.0f;
                } else if (MediaType.APPLICATION_JAVA_OBJECT.isCompatible(target.getMediaType())) {
                    result = 0.6f;
                } else if (MediaType.APPLICATION_JAVA_OBJECT_XML.equals(target.getMediaType())) {
                    result = 1.0f;
                } else if (MediaType.APPLICATION_JAVA_OBJECT_XML.isCompatible(target.getMediaType())) {
                    result = 0.6f;
                }
            } else {
                result = 0.5f;
            }
        }
        return result;
    }

    @Override
    public <T> float score(Representation source, Class<T> target, UniformResource resource) {
        float result = -1.0f;
        if (target != null) {
            if (Representation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (String.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (StringRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (EmptyRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (File.class.isAssignableFrom(target)) {
                if (source instanceof FileRepresentation) {
                    result = 1.0f;
                }
            } else if (Form.class.isAssignableFrom(target)) {
                result = MediaType.APPLICATION_WWW_FORM.isCompatible(source.getMediaType()) ? 1.0f : 0.5f;
            } else if (InputStream.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (InputRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (Reader.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (ReaderRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (Serializable.class.isAssignableFrom(target)) {
                result = MediaType.APPLICATION_JAVA_OBJECT.equals(source.getMediaType()) ? 1.0f : (MediaType.APPLICATION_JAVA_OBJECT.isCompatible(source.getMediaType()) ? 0.6f : (MediaType.APPLICATION_JAVA_OBJECT_XML.equals(source.getMediaType()) ? 1.0f : (MediaType.APPLICATION_JAVA_OBJECT_XML.isCompatible(source.getMediaType()) ? 0.6f : 0.5f)));
            }
        }
        return result;
    }

    @Override
    public <T> T toObject(Representation source, Class<T> target, UniformResource resource) throws IOException {
        Object result = null;
        if (target.isAssignableFrom(source.getClass())) {
            result = source;
        } else if (String.class.isAssignableFrom(target)) {
            result = source.getText();
        } else if (StringRepresentation.class.isAssignableFrom(target)) {
            result = new StringRepresentation((CharSequence)source.getText(), source.getMediaType());
        } else if (EmptyRepresentation.class.isAssignableFrom(target)) {
            result = null;
        } else if (File.class.isAssignableFrom(target)) {
            if (source instanceof FileRepresentation) {
                result = ((FileRepresentation)source).getFile();
            }
        } else if (Form.class.isAssignableFrom(target)) {
            result = new Form(source);
        } else if (InputStream.class.isAssignableFrom(target)) {
            result = source.getStream();
        } else if (InputRepresentation.class.isAssignableFrom(target)) {
            result = new InputRepresentation(source.getStream());
        } else if (Reader.class.isAssignableFrom(target)) {
            result = source.getReader();
        } else if (ReaderRepresentation.class.isAssignableFrom(target)) {
            result = new ReaderRepresentation(source.getReader());
        } else if (Serializable.class.isAssignableFrom(target)) {
            try {
                result = new ObjectRepresentation(source).getObject();
            }
            catch (Exception e) {
                IOException ioe = new IOException("Unable to create the Object representation");
                ioe.initCause(e);
            }
        }
        return (T)result;
    }

    @Override
    public Representation toRepresentation(Object source, Variant target, UniformResource resource) throws IOException {
        Representation result = null;
        if (source instanceof String) {
            result = new StringRepresentation((CharSequence)((String)source), target.getMediaType());
        } else if (source instanceof File) {
            result = new FileRepresentation((File)source, target.getMediaType());
        } else if (source instanceof Form) {
            result = ((Form)source).getWebRepresentation();
        } else if (source instanceof InputStream) {
            result = new InputRepresentation((InputStream)source, target.getMediaType());
        } else if (source instanceof Reader) {
            result = new ReaderRepresentation((Reader)source, target.getMediaType());
        } else if (source instanceof Representation) {
            result = (Representation)source;
        } else if (source instanceof Serializable) {
            result = new ObjectRepresentation<Serializable>((Serializable)source, target.getMediaType());
        }
        return result;
    }
}

