/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jsslutils.keystores.KeyStoreLoader;
import org.jsslutils.sslcontext.PKIXSSLContextFactory;
import org.jsslutils.sslcontext.SSLContextFactory;
import org.jsslutils.sslcontext.X509KeyManagerWrapper;
import org.jsslutils.sslcontext.keymanagers.FixedServerAliasKeyManager;
import org.restlet.data.Parameter;
import org.restlet.ext.ssl.DefaultSslContextFactory;
import org.restlet.ext.ssl.SslContextFactory;
import org.restlet.util.Series;

public class PkixSslContextFactory
extends SslContextFactory {
    private String sslProtocol = "TLS";
    private PKIXSSLContextFactory sslContextFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLContext createSslContext() throws Exception {
        PkixSslContextFactory pkixSslContextFactory = this;
        synchronized (pkixSslContextFactory) {
            return this.sslContextFactory.buildSSLContext(this.sslProtocol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Series<Parameter> parameters) {
        String trustStoreProvider;
        String trustStoreType;
        String trustStorePassword;
        String keyStoreProvider;
        String keyStoreType;
        String keyStorePassword;
        KeyStoreLoader keyStoreLoader = KeyStoreLoader.getKeyStoreDefaultLoader();
        String keyStorePath = parameters.getFirstValue("keystorePath");
        if (keyStorePath != null) {
            keyStoreLoader.setKeyStorePath(keyStorePath);
        }
        if ((keyStorePassword = parameters.getFirstValue("keystorePassword")) != null) {
            keyStoreLoader.setKeyStorePassword(keyStorePassword);
        }
        if ((keyStoreType = parameters.getFirstValue("keystoreType")) != null) {
            keyStoreLoader.setKeyStoreType(keyStoreType);
        }
        if ((keyStoreProvider = parameters.getFirstValue("keystoreProvider")) != null) {
            keyStoreLoader.setKeyStoreProvider(keyStoreProvider);
        }
        KeyStoreLoader trustStoreLoader = KeyStoreLoader.getTrustStoreDefaultLoader();
        String trustStorePath = parameters.getFirstValue("truststorePath");
        if (trustStorePath != null) {
            trustStoreLoader.setKeyStorePath(trustStorePath);
        }
        if ((trustStorePassword = parameters.getFirstValue("truststorePassword")) != null) {
            trustStoreLoader.setKeyStorePassword(trustStorePassword);
        }
        if ((trustStoreType = parameters.getFirstValue("truststoreType")) != null) {
            trustStoreLoader.setKeyStoreType(trustStoreType);
        }
        if ((trustStoreProvider = parameters.getFirstValue("truststoreProvider")) != null) {
            trustStoreLoader.setKeyStoreProvider(trustStoreProvider);
        }
        String keyPassword = parameters.getFirstValue("keyPassword", "");
        String sslProtocol = parameters.getFirstValue("sslProtocol");
        String serverAlias = parameters.getFirstValue("sslServerAlias");
        boolean disableRevocation = Boolean.parseBoolean(parameters.getFirstValue("disableCrl"));
        try {
            String[] crlArray;
            KeyStore keyStore = keyStoreLoader.loadKeyStore();
            KeyStore trustStore = trustStoreLoader.loadKeyStore();
            PKIXSSLContextFactory sslContextFactory = new PKIXSSLContextFactory(keyStore, keyPassword, trustStore, !disableRevocation);
            if (serverAlias != null) {
                sslContextFactory.setKeyManagerWrapper((X509KeyManagerWrapper)new FixedServerAliasKeyManager.Wrapper(serverAlias));
            }
            if ((crlArray = parameters.getValuesArray("crlUrl")) != null) {
                for (String crlUrl : crlArray) {
                    sslContextFactory.addCrl(crlUrl);
                }
            }
            PkixSslContextFactory pkixSslContextFactory = this;
            synchronized (pkixSslContextFactory) {
                this.sslContextFactory = sslContextFactory;
                if (sslProtocol != null) {
                    this.sslProtocol = sslProtocol;
                }
            }
        }
        catch (SSLContextFactory.SSLContextFactoryException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedCallbackException e) {
            throw new RuntimeException(e);
        }
    }

    protected final DefaultSslContextFactory clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

