/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.engine.Edition;
import org.restlet.engine.connector.ConnectorHelper;
import org.restlet.engine.connector.FtpClientHelper;
import org.restlet.engine.connector.HttpClientHelper;
import org.restlet.engine.connector.HttpProtocolHelper;
import org.restlet.engine.connector.HttpServerHelper;
import org.restlet.engine.connector.HttpsServerHelper;
import org.restlet.engine.connector.ProtocolHelper;
import org.restlet.engine.connector.WebDavProtocolHelper;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.converter.DefaultConverter;
import org.restlet.engine.converter.StatusInfoHtmlConverter;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.local.ClapClientHelper;
import org.restlet.engine.local.FileClientHelper;
import org.restlet.engine.local.RiapClientHelper;
import org.restlet.engine.local.RiapServerHelper;
import org.restlet.engine.local.ZipClientHelper;
import org.restlet.engine.log.LoggerFacade;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.security.HttpBasicHelper;
import org.restlet.engine.security.SmtpPlainHelper;
import org.restlet.engine.util.EngineClassLoader;
import org.restlet.routing.VirtualHost;

public class Engine {
    public static final String DESCRIPTOR = "META-INF/services";
    public static final String DESCRIPTOR_AUTHENTICATOR = "org.restlet.engine.security.AuthenticatorHelper";
    public static final String DESCRIPTOR_AUTHENTICATOR_PATH = "META-INF/services/org.restlet.engine.security.AuthenticatorHelper";
    public static final String DESCRIPTOR_CLIENT = "org.restlet.engine.ClientHelper";
    public static final String DESCRIPTOR_CLIENT_PATH = "META-INF/services/org.restlet.engine.ClientHelper";
    public static final String DESCRIPTOR_CONVERTER = "org.restlet.engine.converter.ConverterHelper";
    public static final String DESCRIPTOR_CONVERTER_PATH = "META-INF/services/org.restlet.engine.converter.ConverterHelper";
    public static final String DESCRIPTOR_PROTOCOL = "org.restlet.engine.ProtocolHelper";
    public static final String DESCRIPTOR_PROTOCOL_PATH = "META-INF/services/org.restlet.engine.ProtocolHelper";
    public static final String DESCRIPTOR_SERVER = "org.restlet.engine.ServerHelper";
    public static final String DESCRIPTOR_SERVER_PATH = "META-INF/services/org.restlet.engine.ServerHelper";
    private static volatile Engine instance = null;
    public static final String MAJOR_NUMBER = "2";
    public static final String MINOR_NUMBER = "3";
    public static final String RELEASE_NUMBER = "rc2";
    public static final String VERSION = "2.3rc2";
    public static final String VERSION_HEADER = "Restlet-Framework/2.3rc2";
    private volatile ClassLoader classLoader;
    private LoggerFacade loggerFacade;
    private final List<AuthenticatorHelper> registeredAuthenticators;
    private final List<ConnectorHelper<Client>> registeredClients;
    private final List<ConverterHelper> registeredConverters;
    private final List<ProtocolHelper> registeredProtocols;
    private final List<ConnectorHelper<Server>> registeredServers;
    private volatile ClassLoader userClassLoader;

    public static synchronized void clear() {
        instance = null;
    }

    public static Thread createThreadWithLocalVariables(final Runnable runnable, String name) {
        final Application currentApplication = Application.getCurrent();
        final Context currentContext = Context.getCurrent();
        final Integer currentVirtualHost = VirtualHost.getCurrent();
        final Response currentResponse = Response.getCurrent();
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Response.setCurrent(currentResponse);
                Context.setCurrent(currentContext);
                VirtualHost.setCurrent(currentVirtualHost);
                Application.setCurrent(currentApplication);
                try {
                    runnable.run();
                }
                finally {
                    Engine.clearThreadLocalVariables();
                }
            }
        }, name);
    }

    public static void clearThreadLocalVariables() {
        Response.setCurrent(null);
        Context.setCurrent(null);
        VirtualHost.setCurrent(null);
        Application.setCurrent(null);
    }

    public static Logger getAnonymousLogger() {
        return Engine.getInstance().getLoggerFacade().getAnonymousLogger();
    }

    public static synchronized Engine getInstance() {
        Engine result = instance;
        if (result == null) {
            result = Engine.register();
        }
        return result;
    }

    public static Logger getLogger(Class<?> clazz) {
        return Engine.getInstance().getLoggerFacade().getLogger(clazz);
    }

    public static Logger getLogger(Class<?> clazz, String defaultLoggerName) {
        return Engine.getInstance().getLoggerFacade().getLogger(clazz, defaultLoggerName);
    }

    public static Logger getLogger(Object object, String defaultLoggerName) {
        return Engine.getInstance().getLoggerFacade().getLogger(object, defaultLoggerName);
    }

    public static Logger getLogger(String loggerName) {
        return Engine.getInstance().getLoggerFacade().getLogger(loggerName);
    }

    public static URL getResource(String name) {
        return Engine.getInstance().getClassLoader().getResource(name);
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        return Engine.getInstance().getClassLoader().loadClass(className);
    }

    public static synchronized Engine register() {
        return Engine.register(true);
    }

    public static synchronized Engine register(boolean discoverPlugins) {
        Engine result;
        instance = result = new Engine(discoverPlugins);
        return result;
    }

    public Engine() {
        this(true);
    }

    public Engine(boolean discoverHelpers) {
        instance = this;
        if (Edition.CURRENT == Edition.GWT) {
            this.loggerFacade = new LoggerFacade();
        } else {
            this.classLoader = this.createClassLoader();
            this.userClassLoader = null;
            String loggerFacadeClass = System.getProperty("org.restlet.engine.loggerFacadeClass", "org.restlet.engine.log.LoggerFacade");
            try {
                this.loggerFacade = (LoggerFacade)this.getClassLoader().loadClass(loggerFacadeClass).newInstance();
            }
            catch (Exception e) {
                this.loggerFacade = new LoggerFacade();
                this.loggerFacade.getLogger("org.restlet").log(Level.WARNING, "Unable to register the logger facade", e);
            }
        }
        this.registeredClients = new CopyOnWriteArrayList<ConnectorHelper<Client>>();
        this.registeredProtocols = new CopyOnWriteArrayList<ProtocolHelper>();
        this.registeredServers = new CopyOnWriteArrayList<ConnectorHelper<Server>>();
        this.registeredAuthenticators = new CopyOnWriteArrayList<AuthenticatorHelper>();
        this.registeredConverters = new CopyOnWriteArrayList<ConverterHelper>();
        if (discoverHelpers) {
            try {
                this.discoverConnectors();
                this.discoverProtocols();
                this.discoverAuthenticators();
                this.discoverConverters();
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "An error occured while discovering the engine helpers.", e);
            }
        }
    }

    protected ClassLoader createClassLoader() {
        return new EngineClassLoader(this);
    }

    public ConnectorHelper<Client> createHelper(Client client, String helperClass) {
        ConnectorHelper result = null;
        if (!client.getProtocols().isEmpty()) {
            ConnectorHelper<Client> connector = null;
            Iterator<ConnectorHelper<Client>> iter = this.getRegisteredClients().iterator();
            while (result == null && iter.hasNext()) {
                connector = iter.next();
                if (!connector.getProtocols().containsAll(client.getProtocols()) || helperClass != null && !connector.getClass().getCanonicalName().equals(helperClass)) continue;
                try {
                    result = (ConnectorHelper)connector.getClass().getConstructor(Client.class).newInstance(client);
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.SEVERE, "Exception during the instantiation of the client connector.", e);
                }
            }
            if (result == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("No available client connector supports the required protocols: ");
                for (Protocol p : client.getProtocols()) {
                    sb.append("'").append(p.getName()).append("' ");
                }
                sb.append(". Please add the JAR of a matching connector to your classpath.");
                if (Edition.CURRENT == Edition.ANDROID) {
                    sb.append(" Then, register this connector helper manually.");
                }
                Context.getCurrentLogger().log(Level.WARNING, sb.toString());
            }
        }
        return result;
    }

    public ConnectorHelper<Server> createHelper(Server server, String helperClass) {
        ConnectorHelper result = null;
        if (!server.getProtocols().isEmpty()) {
            ConnectorHelper<Server> connector = null;
            Iterator<ConnectorHelper<Server>> iter = this.getRegisteredServers().iterator();
            while (result == null && iter.hasNext()) {
                connector = iter.next();
                if (helperClass != null && !connector.getClass().getCanonicalName().equals(helperClass) || !connector.getProtocols().containsAll(server.getProtocols())) continue;
                try {
                    result = (ConnectorHelper)connector.getClass().getConstructor(Server.class).newInstance(server);
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.SEVERE, "Exception while instantiation the server connector.", e);
                }
            }
            if (result == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("No available server connector supports the required protocols: ");
                for (Protocol p : server.getProtocols()) {
                    sb.append("'").append(p.getName()).append("' ");
                }
                sb.append(". Please add the JAR of a matching connector to your classpath.");
                if (Edition.CURRENT == Edition.ANDROID) {
                    sb.append(" Then, register this connector helper manually.");
                }
                Context.getCurrentLogger().log(Level.WARNING, sb.toString());
            }
        }
        return result;
    }

    private void discoverAuthenticators() throws IOException {
        this.registerHelpers(DESCRIPTOR_AUTHENTICATOR_PATH, this.getRegisteredAuthenticators(), null);
        this.registerDefaultAuthentications();
    }

    private void discoverConnectors() throws IOException {
        this.registerHelpers(DESCRIPTOR_CLIENT_PATH, this.getRegisteredClients(), Client.class);
        this.registerHelpers(DESCRIPTOR_SERVER_PATH, this.getRegisteredServers(), Server.class);
        this.registerDefaultConnectors();
    }

    private void discoverConverters() throws IOException {
        this.registerHelpers(DESCRIPTOR_CONVERTER_PATH, this.getRegisteredConverters(), null);
        this.registerDefaultConverters();
    }

    private void discoverProtocols() throws IOException {
        this.registerHelpers(DESCRIPTOR_PROTOCOL_PATH, this.getRegisteredProtocols(), null);
        this.registerDefaultProtocols();
    }

    public ConverterHelper findHelper() {
        return null;
    }

    public AuthenticatorHelper findHelper(ChallengeScheme challengeScheme, boolean clientSide, boolean serverSide) {
        AuthenticatorHelper result = null;
        List<AuthenticatorHelper> helpers = this.getRegisteredAuthenticators();
        for (int i = 0; result == null && i < helpers.size(); ++i) {
            AuthenticatorHelper current = helpers.get(i);
            if (!current.getChallengeScheme().equals(challengeScheme) || (!clientSide || !current.isClientSide()) && clientSide || (!serverSide || !current.isServerSide()) && serverSide) continue;
            result = helpers.get(i);
        }
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public LoggerFacade getLoggerFacade() {
        return this.loggerFacade;
    }

    private String getProviderClassName(String line) {
        int index = line.indexOf(35);
        if (index != -1) {
            line = line.substring(0, index);
        }
        return line.trim();
    }

    public List<AuthenticatorHelper> getRegisteredAuthenticators() {
        return this.registeredAuthenticators;
    }

    public List<ConnectorHelper<Client>> getRegisteredClients() {
        return this.registeredClients;
    }

    public List<ConverterHelper> getRegisteredConverters() {
        return this.registeredConverters;
    }

    public List<ProtocolHelper> getRegisteredProtocols() {
        return this.registeredProtocols;
    }

    public List<ConnectorHelper<Server>> getRegisteredServers() {
        return this.registeredServers;
    }

    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    public void registerDefaultAuthentications() {
        this.getRegisteredAuthenticators().add(new HttpBasicHelper());
        this.getRegisteredAuthenticators().add(new SmtpPlainHelper());
    }

    public void registerDefaultConnectors() {
        this.getRegisteredClients().add(new FtpClientHelper(null));
        this.getRegisteredClients().add(new HttpClientHelper(null));
        this.getRegisteredClients().add(new ClapClientHelper(null));
        this.getRegisteredClients().add(new RiapClientHelper(null));
        this.getRegisteredServers().add(new RiapServerHelper(null));
        this.getRegisteredServers().add(new HttpServerHelper(null));
        this.getRegisteredServers().add(new HttpsServerHelper(null));
        this.getRegisteredClients().add(new FileClientHelper(null));
        this.getRegisteredClients().add(new ZipClientHelper(null));
    }

    public void registerDefaultConverters() {
        this.getRegisteredConverters().add(new DefaultConverter());
        this.getRegisteredConverters().add(new StatusInfoHtmlConverter());
    }

    public void registerDefaultProtocols() {
        this.getRegisteredProtocols().add(new HttpProtocolHelper());
        this.getRegisteredProtocols().add(new WebDavProtocolHelper());
    }

    public void registerHelper(ClassLoader classLoader, String provider, List helpers, Class constructorClass) {
        if (provider != null && !provider.equals("")) {
            try {
                Class<?> providerClass = classLoader.loadClass(provider);
                if (constructorClass == null) {
                    helpers.add(providerClass.newInstance());
                } else {
                    helpers.add(providerClass.getConstructor(constructorClass).newInstance(constructorClass.cast(null)));
                }
            }
            catch (Throwable t) {
                Context.getCurrentLogger().log(Level.INFO, "Unable to register the helper " + provider, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHelpers(ClassLoader classLoader, URL configUrl, List<?> helpers, Class<?> constructorClass) {
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(configUrl.openStream(), "utf-8"), IoUtils.BUFFER_SIZE);
            String line = reader.readLine();
            while (line != null) {
                this.registerHelper(classLoader, this.getProviderClassName(line), helpers, constructorClass);
                line = reader.readLine();
            }
        }
        catch (IOException ioe) {
            Context.getCurrentLogger().log(Level.SEVERE, "Exception while detecting the helpers.", ioe);
        }
    }

    public void registerHelpers(String descriptorPath, List<?> helpers, Class<?> constructorClass) throws IOException {
        ClassLoader classLoader = this.getClassLoader();
        Enumeration<URL> configUrls = classLoader.getResources(descriptorPath);
        if (configUrls != null) {
            Enumeration<URL> configEnum = configUrls;
            while (configEnum.hasMoreElements()) {
                this.registerHelpers(classLoader, configEnum.nextElement(), helpers, constructorClass);
            }
        }
    }

    public void registerUrlFactory() {
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                URLStreamHandler result = new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL url) throws IOException {
                        return new URLConnection(url){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                Response response;
                                InputStream result = null;
                                Context context = Context.getCurrent();
                                if (context != null && (response = context.getClientDispatcher().handle(new Request(Method.GET, this.url.toString()))).getStatus().isSuccess()) {
                                    result = response.getEntity().getStream();
                                }
                                return result;
                            }
                        };
                    }
                };
                return result;
            }
        });
    }

    public void setClassLoader(ClassLoader newClassLoader) {
        this.classLoader = newClassLoader;
    }

    public void setLoggerFacade(LoggerFacade loggerFacade) {
        this.loggerFacade = loggerFacade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisteredAuthenticators(List<AuthenticatorHelper> registeredAuthenticators) {
        List<AuthenticatorHelper> list = this.registeredAuthenticators;
        synchronized (list) {
            if (registeredAuthenticators != this.registeredAuthenticators) {
                this.registeredAuthenticators.clear();
                if (registeredAuthenticators != null) {
                    this.registeredAuthenticators.addAll(registeredAuthenticators);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisteredClients(List<ConnectorHelper<Client>> registeredClients) {
        List<ConnectorHelper<Client>> list = this.registeredClients;
        synchronized (list) {
            if (registeredClients != this.registeredClients) {
                this.registeredClients.clear();
                if (registeredClients != null) {
                    this.registeredClients.addAll(registeredClients);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisteredConverters(List<ConverterHelper> registeredConverters) {
        List<ConverterHelper> list = this.registeredConverters;
        synchronized (list) {
            if (registeredConverters != this.registeredConverters) {
                this.registeredConverters.clear();
                if (registeredConverters != null) {
                    this.registeredConverters.addAll(registeredConverters);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisteredProtocols(List<ProtocolHelper> registeredProtocols) {
        List<ProtocolHelper> list = this.registeredProtocols;
        synchronized (list) {
            if (registeredProtocols != this.registeredProtocols) {
                this.registeredProtocols.clear();
                if (registeredProtocols != null) {
                    this.registeredProtocols.addAll(registeredProtocols);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisteredServers(List<ConnectorHelper<Server>> registeredServers) {
        List<ConnectorHelper<Server>> list = this.registeredServers;
        synchronized (list) {
            if (registeredServers != this.registeredServers) {
                this.registeredServers.clear();
                if (registeredServers != null) {
                    this.registeredServers.addAll(registeredServers);
                }
            }
        }
    }

    public void setUserClassLoader(ClassLoader newClassLoader) {
        this.userClassLoader = newClassLoader;
    }
}

