/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import org.restlet.data.Encoding;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;
import org.restlet.util.WrapperRepresentation;

public class DecodeRepresentation
extends WrapperRepresentation {
    private volatile boolean decoding;
    private final List<Encoding> wrappedEncodings;

    public static List<Encoding> getSupportedEncodings() {
        return Arrays.asList(Encoding.GZIP, Encoding.DEFLATE, Encoding.DEFLATE_NOWRAP, Encoding.ZIP, Encoding.IDENTITY);
    }

    public DecodeRepresentation(Representation wrappedRepresentation) {
        super(wrappedRepresentation);
        this.decoding = DecodeRepresentation.getSupportedEncodings().containsAll(wrappedRepresentation.getEncodings());
        this.wrappedEncodings = new CopyOnWriteArrayList<Encoding>(wrappedRepresentation.getEncodings());
    }

    @Override
    public ReadableByteChannel getChannel() throws IOException {
        if (this.isDecoding()) {
            return NioUtils.getChannel(this.getStream());
        }
        return this.getWrappedRepresentation().getChannel();
    }

    private InputStream getDecodedStream(Encoding encoding, InputStream encodedStream) throws IOException {
        InflaterInputStream result = null;
        if (encodedStream != null) {
            if (encoding.equals(Encoding.GZIP)) {
                result = new GZIPInputStream(encodedStream);
            } else if (encoding.equals(Encoding.DEFLATE)) {
                result = new InflaterInputStream(encodedStream);
            } else if (encoding.equals(Encoding.DEFLATE_NOWRAP)) {
                result = new InflaterInputStream(encodedStream, new Inflater(true));
            } else if (encoding.equals(Encoding.ZIP)) {
                ZipInputStream stream = new ZipInputStream(encodedStream);
                if (stream.getNextEntry() != null) {
                    result = stream;
                }
            } else if (encoding.equals(Encoding.IDENTITY)) {
                throw new IOException("Decoder unecessary for identity decoding");
            }
        }
        return result;
    }

    @Override
    public List<Encoding> getEncodings() {
        if (this.isDecoding()) {
            return new ArrayList<Encoding>();
        }
        return this.wrappedEncodings;
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.isDecoding()) {
            return BioUtils.getReader(this.getStream(), this.getCharacterSet());
        }
        return this.getWrappedRepresentation().getReader();
    }

    @Override
    public long getSize() {
        long result = -1L;
        if (this.isDecoding()) {
            boolean identity = true;
            Iterator<Encoding> iter = this.getEncodings().iterator();
            while (identity && iter.hasNext()) {
                identity = iter.next().equals(Encoding.IDENTITY);
            }
            if (identity) {
                result = this.getWrappedRepresentation().getSize();
            }
        } else {
            result = this.getWrappedRepresentation().getSize();
        }
        return result;
    }

    @Override
    public InputStream getStream() throws IOException {
        InputStream result = this.getWrappedRepresentation().getStream();
        if (this.isDecoding()) {
            for (int i = this.wrappedEncodings.size() - 1; i >= 0; --i) {
                if (this.wrappedEncodings.get(i).equals(Encoding.IDENTITY)) continue;
                result = this.getDecodedStream(this.wrappedEncodings.get(i), result);
            }
        }
        return result;
    }

    @Override
    public String getText() throws IOException {
        if (this.isDecoding()) {
            return BioUtils.toString(this.getStream(), this.getCharacterSet());
        }
        return this.getWrappedRepresentation().getText();
    }

    public boolean isDecoding() {
        return this.decoding;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this.isDecoding()) {
            BioUtils.copy(this.getStream(), outputStream);
        } else {
            this.getWrappedRepresentation().write(outputStream);
        }
    }

    @Override
    public void write(WritableByteChannel writableChannel) throws IOException {
        if (this.isDecoding()) {
            OutputStream os = NioUtils.getStream(writableChannel);
            this.write(os);
            os.flush();
        } else {
            this.getWrappedRepresentation().write(writableChannel);
        }
    }
}

