/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.restlet.data.Encoding;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;
import org.restlet.util.WrapperList;
import org.restlet.util.WrapperRepresentation;

public class EncodeRepresentation
extends WrapperRepresentation {
    private volatile boolean canEncode;
    private volatile Encoding encoding;
    private volatile List<Encoding> encodings;

    public static List<Encoding> getSupportedEncodings() {
        return Arrays.asList(Encoding.GZIP, Encoding.DEFLATE, Encoding.ZIP, Encoding.IDENTITY);
    }

    public EncodeRepresentation(Encoding encoding, Representation wrappedRepresentation) {
        super(wrappedRepresentation);
        this.canEncode = EncodeRepresentation.getSupportedEncodings().contains(encoding);
        this.encodings = null;
        this.encoding = encoding;
    }

    public boolean canEncode() {
        return this.canEncode;
    }

    @Override
    public long getAvailableSize() {
        long result = -1L;
        if (this.canEncode()) {
            if (this.encoding.equals(Encoding.IDENTITY)) {
                result = this.getWrappedRepresentation().getAvailableSize();
            }
        } else {
            result = this.getWrappedRepresentation().getAvailableSize();
        }
        return result;
    }

    @Override
    public ReadableByteChannel getChannel() throws IOException {
        if (this.canEncode()) {
            return NioUtils.getChannel(this);
        }
        return this.getWrappedRepresentation().getChannel();
    }

    @Override
    public List<Encoding> getEncodings() {
        if (this.encodings == null) {
            this.encodings = new WrapperList<Encoding>(){

                @Override
                public boolean add(Encoding element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.add(element);
                }

                @Override
                public void add(int index, Encoding element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    super.add(index, element);
                }

                @Override
                public boolean addAll(Collection<? extends Encoding> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Encoding> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.addAll(elements);
                }

                @Override
                public boolean addAll(int index, Collection<? extends Encoding> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Encoding> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.addAll(index, elements);
                }
            };
            this.encodings.addAll(this.getWrappedRepresentation().getEncodings());
            if (this.canEncode()) {
                this.encodings.add(this.encoding);
            }
        }
        return this.encodings;
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.canEncode()) {
            return BioUtils.getReader(this.getStream(), this.getCharacterSet());
        }
        return this.getWrappedRepresentation().getReader();
    }

    @Override
    public long getSize() {
        long result = -1L;
        if (this.canEncode()) {
            if (this.encoding.equals(Encoding.IDENTITY)) {
                result = this.getWrappedRepresentation().getSize();
            }
        } else {
            result = this.getWrappedRepresentation().getSize();
        }
        return result;
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.canEncode()) {
            return BioUtils.getStream(this);
        }
        return this.getWrappedRepresentation().getStream();
    }

    @Override
    public String getText() throws IOException {
        if (this.canEncode()) {
            return BioUtils.toString(this.getStream(), this.getCharacterSet());
        }
        return this.getWrappedRepresentation().getText();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this.canEncode()) {
            DeflaterOutputStream encoderOutputStream = null;
            if (this.encoding.equals(Encoding.GZIP)) {
                encoderOutputStream = new GZIPOutputStream(outputStream);
            } else if (this.encoding.equals(Encoding.DEFLATE)) {
                encoderOutputStream = new DeflaterOutputStream(outputStream);
            } else if (this.encoding.equals(Encoding.ZIP)) {
                ZipOutputStream stream = new ZipOutputStream(outputStream);
                String name = "entry";
                if (this.getWrappedRepresentation().getDisposition() != null) {
                    name = this.getWrappedRepresentation().getDisposition().getParameters().getFirstValue("filename", true, name);
                }
                stream.putNextEntry(new ZipEntry(name));
                encoderOutputStream = stream;
            } else if (this.encoding.equals(Encoding.IDENTITY)) {
                // empty if block
            }
            if (encoderOutputStream != null) {
                this.getWrappedRepresentation().write(encoderOutputStream);
                encoderOutputStream.flush();
                encoderOutputStream.finish();
            } else {
                this.getWrappedRepresentation().write(outputStream);
            }
        } else {
            this.getWrappedRepresentation().write(outputStream);
        }
    }

    @Override
    public void write(WritableByteChannel writableChannel) throws IOException {
        if (this.canEncode()) {
            OutputStream os = NioUtils.getStream(writableChannel);
            this.write(os);
            os.flush();
        } else {
            this.getWrappedRepresentation().write(writableChannel);
        }
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (this.canEncode()) {
            OutputStream os = BioUtils.getStream(writer, this.getCharacterSet());
            this.write(os);
            os.flush();
        } else {
            this.getWrappedRepresentation().write(writer);
        }
    }
}

