/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerList
extends WrapperList<Server> {
    private volatile Context context;
    private volatile Restlet next;

    public ServerList(Context context, Restlet next) {
        super(new CopyOnWriteArrayList());
        this.context = context;
        this.next = next;
    }

    public Server add(Protocol protocol) {
        Server result = new Server(protocol, null, protocol.getDefaultPort(), this.getNext());
        this.add(result);
        return result;
    }

    public Server add(Protocol protocol, int port) {
        Server result = new Server(protocol, null, port, this.getNext());
        this.add(result);
        return result;
    }

    public Server add(Protocol protocol, String address, int port) {
        Server result = new Server(protocol, address, port, this.getNext());
        this.add(result);
        return result;
    }

    @Override
    public boolean add(Server server) {
        if (server.getContext() == null) {
            server.setContext(this.getContext().createChildContext());
        }
        server.setNext(this.getNext());
        return super.add(server);
    }

    public Context getContext() {
        return this.context;
    }

    public Restlet getNext() {
        return this.next;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Deprecated
    public void setNext(Class<? extends ServerResource> nextClass) {
        this.setNext(Finder.createFinder(nextClass, Finder.class, this.getContext(), this.getContext().getLogger()));
    }

    public void setNext(Restlet next) {
        this.next = next;
    }
}

