/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.ConnectorHelper;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.EntityType;
import org.restlet.engine.connector.MessageState;
import org.restlet.engine.connector.Way;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.io.BlockableChannel;
import org.restlet.engine.io.Buffer;
import org.restlet.engine.io.IoState;
import org.restlet.engine.io.ReadableChunkingChannel;
import org.restlet.engine.io.ReadableSizedChannel;
import org.restlet.engine.util.StringUtils;
import org.restlet.representation.Representation;
import org.restlet.service.ConnectorService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutboundWay
extends Way {
    private volatile ReadableByteChannel entityChannel = null;
    private volatile EntityType entityChannelType;
    private volatile SelectionKey entitySelectionKey = null;
    private volatile int headerIndex = 0;

    protected static String getVersion(Request request) {
        Protocol protocol = request.getProtocol();
        String protocolVersion = protocol.getVersion();
        return protocol.getTechnicalName() + '/' + (protocolVersion == null ? "1.1" : protocolVersion);
    }

    public OutboundWay(Connection<?> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    protected void addEntityHeaders(Representation entity, Series<Header> headers) {
        HeaderUtils.addEntityHeaders(entity, headers);
    }

    protected void addGeneralHeaders(Series<Header> headers) {
        if (!this.getConnection().isPersistent()) {
            headers.set("Connection", "close", true);
        }
        if (this.shouldBeChunked(this.getActualMessage().getEntity())) {
            headers.add("Transfer-Encoding", "chunked");
        }
        HeaderUtils.addGeneralHeaders(this.getActualMessage(), headers);
    }

    protected abstract void addHeaders(Series<Header> var1);

    protected boolean canStart() {
        return this.getMessageState() == MessageState.IDLE && this.getMessage() != null;
    }

    @Override
    public void clear() {
        super.clear();
        this.entityChannel = null;
        this.entitySelectionKey = null;
        this.headerIndex = 0;
    }

    public ReadableByteChannel getEntityChannel() {
        return this.entityChannel;
    }

    protected EntityType getEntityChannelType() {
        return this.entityChannelType;
    }

    public FileChannel getEntityFileChannel() {
        return (FileChannel)this.getEntityChannel();
    }

    public int getEntityInterestOps() {
        int result = 0;
        if (this.getIoState() == IoState.INTEREST) {
            result = 1;
        }
        return result;
    }

    public SelectableChannel getEntitySelectableChannel() {
        return (SelectableChannel)((Object)this.getEntityChannel());
    }

    public SelectionKey getEntitySelectionKey() {
        return this.entitySelectionKey;
    }

    protected int getHeaderIndex() {
        return this.headerIndex;
    }

    @Override
    public int getInterestOperations() {
        int result = 0;
        if (this.getIoState() == IoState.INTEREST) {
            result = 4;
        }
        return result;
    }

    protected abstract void handle(Response var1);

    protected boolean hasIoInterest() {
        return this.getMessageState() == MessageState.START || this.getBuffer().canDrain();
    }

    @Override
    public void onCompleted(boolean endReached) {
        if (this.getActualMessage() != null) {
            ConnectorService connectorService;
            Representation messageEntity = this.getActualMessage().getEntity();
            if (messageEntity != null) {
                messageEntity.release();
            }
            if ((connectorService = ConnectorHelper.getConnectorService()) != null) {
                connectorService.afterSend(messageEntity);
            }
        }
        super.onCompleted(endReached);
        this.setHeaderIndex(0);
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Outbound message completed");
        }
    }

    @Override
    public int onDrain(Buffer buffer, int maxDrained, Object ... args) throws IOException {
        int result = this.getBuffer().drain(this.getConnection().getWritableSelectionChannel());
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, result + " bytes written");
        }
        if (this.getHelper().getThrottleTimeMs() > 0) {
            try {
                Thread.sleep(this.getHelper().getThrottleTimeMs());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (result == 0 && this.getIoState() == IoState.PROCESSING) {
            this.setIoState(IoState.INTEREST);
        }
        return result;
    }

    @Override
    public void onError(Status status) {
        this.getHelper().onOutboundError(status, this.getMessage());
        this.setMessage(null);
    }

    @Override
    public int onFill(Buffer buffer, Object ... args) throws IOException {
        int remaining = buffer.remaining();
        if (this.getMessageState() == MessageState.BODY) {
            int filled = buffer.fill(this.getEntityChannel());
            if (filled == -1) {
                this.setMessageState(MessageState.END);
            }
        } else if (this.getMessageState() != MessageState.END) {
            if (this.getLineBuilder().length() == 0) {
                this.writeLine();
            }
            if (this.getLineBuilder().length() > 0) {
                if (remaining >= this.getLineBuilder().length()) {
                    buffer.fill(StringUtils.getLatin1Bytes(this.getLineBuilder().toString()));
                    if (this.getLogger().isLoggable(Level.FINE)) {
                        String line = this.getLineBuilder().toString();
                        line = line.substring(0, line.length() - 2);
                        this.getLogger().log(Level.FINE, line);
                    }
                    this.clearLineBuilder();
                } else {
                    buffer.fill(StringUtils.getLatin1Bytes(this.getLineBuilder().substring(0, remaining)));
                    this.getLineBuilder().delete(0, remaining);
                }
            }
        }
        return remaining - buffer.remaining();
    }

    @Override
    public void onFillEof() {
    }

    @Override
    protected void onPostProcessing() {
        if (this.getMessageState() != MessageState.IDLE || this.getBuffer().canDrain()) {
            super.onPostProcessing();
        }
    }

    @Override
    public void onTimeOut() {
        if (this.getMessage() != null) {
            this.getHelper().onOutboundError(Status.CONNECTOR_ERROR_COMMUNICATION, this.getMessage());
        }
    }

    @Override
    public int processIoBuffer() throws IOException {
        int result = super.processIoBuffer();
        if (this.getMessage() != null) {
            if (this.getMessageState() == MessageState.END) {
                this.onCompleted(false);
            } else if (this.getMessageState() == MessageState.IDLE) {
                this.updateState();
            }
        }
        return result;
    }

    public void setEntityChannel(ReadableByteChannel entityChannel) {
        this.entityChannel = entityChannel;
    }

    protected void setEntityChannelType(EntityType entityChannelType) {
        this.entityChannelType = entityChannelType;
    }

    public void setEntitySelectionKey(SelectionKey entityKey) {
        this.entitySelectionKey = entityKey;
    }

    protected void setHeaderIndex(int headerIndex) {
        this.headerIndex = headerIndex;
    }

    protected boolean shouldBeChunked(Representation entity) {
        return entity != null && entity.getAvailableSize() == -1L;
    }

    @Override
    public void updateState() {
        if (this.canStart()) {
            this.setMessageState(MessageState.START);
        }
        if (this.hasIoInterest()) {
            this.setIoState(IoState.INTEREST);
        }
        super.updateState();
    }

    protected void writeLine() throws IOException {
        switch (this.getMessageState()) {
            case START: {
                if (this.getHelper().getLogger().isLoggable(Level.FINE)) {
                    this.getHelper().getLogger().log(Level.FINE, "Writing message to " + this.getConnection().getSocketAddress());
                }
                this.writeStartLine();
                this.setMessageState(MessageState.HEADERS);
                break;
            }
            case HEADERS: {
                if (this.getHeaders() == null) {
                    this.setHeaders(new Series<Header>(Header.class));
                    this.setHeaderIndex(0);
                    this.addHeaders(this.getHeaders());
                }
                if (this.getHeaderIndex() < this.getHeaders().size()) {
                    Header header = (Header)this.getHeaders().get(this.getHeaderIndex());
                    this.getLineBuilder().append(header.getName());
                    this.getLineBuilder().append(": ");
                    this.getLineBuilder().append(header.getValue());
                    this.getLineBuilder().append('\r');
                    this.getLineBuilder().append('\n');
                    this.setHeaderIndex(this.getHeaderIndex() + 1);
                    break;
                }
                this.getLineBuilder().append('\r');
                this.getLineBuilder().append('\n');
                if (this.getActualMessage().isEntityAvailable()) {
                    ConnectorService connectorService = ConnectorHelper.getConnectorService();
                    if (connectorService != null) {
                        connectorService.afterSend(this.getActualMessage().getEntity());
                    }
                    this.setMessageState(MessageState.BODY);
                    ReadableByteChannel rbc = this.getActualMessage().getEntity().getChannel();
                    if (rbc instanceof FileChannel) {
                        this.setEntityChannelType(EntityType.TRANSFERABLE);
                    } else if (rbc instanceof BlockableChannel) {
                        BlockableChannel bc = (BlockableChannel)((Object)rbc);
                        if (bc.isBlocking()) {
                            this.setEntityChannelType(EntityType.BLOCKING);
                        } else {
                            this.setEntityChannelType(EntityType.NON_BLOCKING);
                        }
                    } else if (rbc instanceof SelectableChannel) {
                        SelectableChannel sc = (SelectableChannel)((Object)rbc);
                        if (sc.isBlocking()) {
                            this.setEntityChannelType(EntityType.BLOCKING);
                        } else {
                            this.setEntityChannelType(EntityType.NON_BLOCKING);
                        }
                    } else {
                        this.setEntityChannelType(EntityType.BLOCKING);
                    }
                    if (this.getActualMessage().getEntity().getAvailableSize() == -1L) {
                        this.setEntityChannel(new ReadableChunkingChannel(rbc, this.getBuffer().capacity()));
                        break;
                    }
                    this.setEntityChannel(new ReadableSizedChannel(rbc, this.getActualMessage().getEntity().getAvailableSize()));
                    break;
                }
                this.setMessageState(MessageState.END);
            }
        }
    }

    protected abstract void writeStartLine() throws IOException;
}

