/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.routing.Filter;
import org.restlet.security.Enroler;

public abstract class Authenticator
extends Filter {
    private volatile boolean optional;
    private volatile Enroler enroler;

    public Authenticator(Context context) {
        this(context, false);
    }

    public Authenticator(Context context, boolean optional) {
        this(context, optional, context != null ? context.getDefaultEnroler() : null);
    }

    public Authenticator(Context context, boolean optional, Enroler enroler) {
        super(context);
        this.optional = optional;
        this.enroler = enroler;
    }

    protected abstract boolean authenticate(Request var1, Response var2);

    protected int beforeHandle(Request request, Response response) {
        if (this.authenticate(request, response)) {
            return this.authenticated(request, response);
        }
        if (this.isOptional()) {
            response.setStatus(Status.SUCCESS_OK);
            return 0;
        }
        return this.unauthenticated(request, response);
    }

    protected int authenticated(Request request, Response response) {
        if (request.getClientInfo() != null) {
            request.getClientInfo().setAuthenticated(true);
        }
        response.getChallengeRequests().clear();
        if (this.getEnroler() != null) {
            this.getEnroler().enrole(request.getClientInfo());
        }
        return 0;
    }

    protected int unauthenticated(Request request, Response response) {
        if (this.isOptional()) {
            response.setStatus(Status.SUCCESS_OK);
            return 0;
        }
        if (request.getClientInfo() != null) {
            request.getClientInfo().setAuthenticated(false);
        }
        return 2;
    }

    public Enroler getEnroler() {
        return this.enroler;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setEnroler(Enroler enroler) {
        this.enroler = enroler;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }
}

