/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHost
extends Router {
    private static final ThreadLocal<Integer> CURRENT = new ThreadLocal();
    private volatile String hostDomain;
    private volatile String hostPort;
    private volatile String hostScheme;
    private volatile Context parentContext;
    private volatile String resourceDomain;
    private volatile String resourcePort;
    private volatile String resourceScheme;
    private volatile String serverAddress;
    private volatile String serverPort;

    public static Integer getCurrent() {
        return CURRENT.get();
    }

    public static String getIpAddress(String domain) {
        String result = null;
        try {
            result = InetAddress.getByName(domain).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public static String getLocalHostAddress() {
        String result = null;
        try {
            result = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public static String getLocalHostName() {
        String result = null;
        try {
            result = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public static void setCurrent(Integer code) {
        CURRENT.set(code);
    }

    public VirtualHost() {
        this(null);
    }

    public VirtualHost(Context parentContext) {
        this(parentContext, ".*", ".*", ".*", ".*", ".*", ".*", ".*", ".*");
    }

    public VirtualHost(Context parentContext, String hostDomain, String hostPort, String hostScheme, String resourceDomain, String resourcePort, String resourceScheme, String serverAddress, String serverPort) {
        super(parentContext == null ? null : parentContext.createChildContext());
        this.setDefaultMatchingMode(1);
        this.setRoutingMode(1);
        this.parentContext = parentContext;
        this.hostDomain = hostDomain;
        this.hostPort = hostPort;
        this.hostScheme = hostScheme;
        this.resourceDomain = resourceDomain;
        this.resourcePort = resourcePort;
        this.resourceScheme = resourceScheme;
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
    }

    @Override
    public TemplateRoute attach(Restlet target) {
        this.checkContext(target);
        return super.attach(target);
    }

    @Override
    public TemplateRoute attach(String uriPattern, Restlet target) {
        this.checkContext(target);
        return super.attach(uriPattern, target);
    }

    @Override
    public TemplateRoute attachDefault(Restlet defaultTarget) {
        this.checkContext(defaultTarget);
        return super.attachDefault(defaultTarget);
    }

    private void checkContext(Restlet target) {
        if (target.getContext() == null && this.parentContext != null) {
            target.setContext(this.parentContext.createChildContext());
        }
    }

    @Override
    public Finder createFinder(Class<? extends ServerResource> targetClass) {
        Finder result = super.createFinder(targetClass);
        result.setContext(this.getContext().createChildContext());
        return result;
    }

    @Override
    protected TemplateRoute createRoute(String uriPattern, Restlet target, int matchingMode) {
        TemplateRoute result = new TemplateRoute(this, uriPattern, target){

            protected int beforeHandle(Request request, Response response) {
                int result = super.beforeHandle(request, response);
                request.setRootRef(request.getResourceRef().getBaseRef());
                VirtualHost.setCurrent(VirtualHost.this.hashCode());
                return result;
            }
        };
        result.getTemplate().setMatchingMode(matchingMode);
        result.setMatchingQuery(this.getDefaultMatchingQuery());
        return result;
    }

    public String getHostDomain() {
        return this.hostDomain;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public String getHostScheme() {
        return this.hostScheme;
    }

    public String getResourceDomain() {
        return this.resourceDomain;
    }

    public String getResourcePort() {
        return this.resourcePort;
    }

    public String getResourceScheme() {
        return this.resourceScheme;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setContext(Context parentContext) {
        this.parentContext = parentContext;
        super.setContext(parentContext == null ? null : parentContext.createChildContext());
    }

    public void setHostDomain(String hostDomain) {
        this.hostDomain = hostDomain;
    }

    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public void setHostScheme(String hostScheme) {
        this.hostScheme = hostScheme;
    }

    public void setResourceDomain(String resourceDomain) {
        this.resourceDomain = resourceDomain;
    }

    public void setResourcePort(String resourcePort) {
        this.resourcePort = resourcePort;
    }

    public void setResourceScheme(String resourceScheme) {
        this.resourceScheme = resourceScheme;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }
}

