/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import org.restlet.Client;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.OutboundWay;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientOutboundWay
extends OutboundWay {
    private static String getRequestUri(Reference resourceRef, boolean isProxied) {
        Reference requestRef;
        String result = null;
        Reference reference = requestRef = resourceRef.isAbsolute() ? resourceRef : resourceRef.getTargetRef();
        if (isProxied) {
            result = requestRef.getIdentifier();
        } else {
            result = requestRef.hasQuery() ? requestRef.getPath() + "?" + requestRef.getQuery() : requestRef.getPath();
            if (result == null || result.equals("")) {
                result = "/";
            }
        }
        return result;
    }

    public ClientOutboundWay(Connection<?> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    protected void addHeaders(Series<Parameter> headers) {
        Request request = this.getMessage().getRequest();
        this.addGeneralHeaders(headers);
        this.addEntityHeaders(request.getEntity(), headers);
        this.addRequestHeaders(headers);
    }

    protected void addRequestHeaders(Series<Parameter> headers) {
        HeaderUtils.addRequestHeaders(this.getMessage().getRequest(), headers);
    }

    @Override
    protected Message getActualMessage() {
        return this.getMessage().getRequest();
    }

    protected Connection<Client> getConnection() {
        return super.getConnection();
    }

    @Override
    public void onCompleted(boolean endDetected) {
        Request request;
        Response message = this.getMessage();
        if (message != null && (request = message.getRequest()).getOnSent() != null) {
            request.getOnSent().handle(request, message);
        }
        super.onCompleted(endDetected);
    }

    @Override
    protected void writeStartLine() throws IOException {
        Request request = this.getMessage().getRequest();
        this.getLineBuilder().append(request.getMethod().getName());
        this.getLineBuilder().append(' ');
        this.getLineBuilder().append(ClientOutboundWay.getRequestUri(request.getResourceRef(), this.getHelper().isProxying()));
        this.getLineBuilder().append(' ');
        this.getLineBuilder().append(ClientOutboundWay.getVersion(request));
        this.getLineBuilder().append("\r\n");
    }
}

