/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.security.cert.Certificate;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Digest;
import org.restlet.data.Parameter;
import org.restlet.engine.ConnectorHelper;
import org.restlet.engine.adapter.Call;
import org.restlet.engine.header.ContentType;
import org.restlet.engine.header.EncodingReader;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.header.LanguageReader;
import org.restlet.engine.header.RangeReader;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.StringUtils;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.service.ConnectorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerCall
extends Call {
    private volatile boolean hostParsed;

    public ServerCall(Server server) {
        this(server.getAddress(), server.getPort());
    }

    public ServerCall(String serverAddress, int serverPort) {
        this.setServerAddress(serverAddress);
        this.setServerPort(serverPort);
        this.hostParsed = false;
    }

    public abstract boolean abort();

    public void complete() {
    }

    protected long getContentLength() {
        return HeaderUtils.getContentLength(this.getRequestHeaders());
    }

    @Override
    public String getHostDomain() {
        if (!this.hostParsed) {
            this.parseHost();
        }
        return super.getHostDomain();
    }

    @Override
    public int getHostPort() {
        if (!this.hostParsed) {
            this.parseHost();
        }
        return super.getHostPort();
    }

    public Representation getRequestEntity() {
        Representation result = null;
        long contentLength = this.getContentLength();
        boolean chunkedEncoding = HeaderUtils.isChunkedEncoding(this.getRequestHeaders());
        boolean connectionClosed = HeaderUtils.isConnectionClose(this.getRequestHeaders());
        if (contentLength != -1L && contentLength != 0L || chunkedEncoding || connectionClosed) {
            InputStream requestStream = this.getRequestEntityStream(contentLength);
            if (connectionClosed) {
                PushbackInputStream pbi = new PushbackInputStream(requestStream);
                try {
                    int next = pbi.read();
                    if (next != -1) {
                        pbi.unread(next);
                        requestStream = pbi;
                    } else {
                        requestStream = null;
                    }
                }
                catch (IOException e) {
                    this.getLogger().fine("Unable to read request entity");
                }
            }
            result = requestStream != null ? new InputRepresentation(requestStream, null, contentLength) : new EmptyRepresentation();
            result.setSize(contentLength);
        } else {
            result = new EmptyRepresentation();
        }
        for (Parameter header : this.getRequestHeaders()) {
            if (header.getName().equalsIgnoreCase("Content-Encoding")) {
                new EncodingReader(header.getValue()).addValues(result.getEncodings());
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Language")) {
                new LanguageReader(header.getValue()).addValues(result.getLanguages());
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Type")) {
                ContentType contentType = new ContentType(header.getValue());
                result.setMediaType(contentType.getMediaType());
                result.setCharacterSet(contentType.getCharacterSet());
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Range")) {
                RangeReader.update(header.getValue(), result);
                continue;
            }
            if (!header.getName().equalsIgnoreCase("Content-MD5")) continue;
            result.setDigest(new Digest("MD5", Base64.decode(header.getValue())));
        }
        return result;
    }

    public abstract InputStream getRequestEntityStream(long var1);

    public abstract InputStream getRequestHeadStream();

    public abstract OutputStream getResponseEntityStream();

    public String getSslCipherSuite() {
        return null;
    }

    public List<Certificate> getSslClientCertificates() {
        return null;
    }

    public Integer getSslKeySize() {
        return null;
    }

    public String getSslSessionId() {
        byte[] byteArray = this.getSslSessionIdBytes();
        if (byteArray != null) {
            return BioUtils.toHexString(byteArray);
        }
        return null;
    }

    protected byte[] getSslSessionIdBytes() {
        return null;
    }

    @Override
    protected boolean isClientKeepAlive() {
        return !HeaderUtils.isConnectionClose(this.getRequestHeaders());
    }

    @Override
    protected boolean isServerKeepAlive() {
        return true;
    }

    private void parseHost() {
        String host = this.getRequestHeaders().getFirstValue("Host", true);
        if (host != null) {
            int colonIndex = host.indexOf(58);
            if (colonIndex != -1) {
                super.setHostDomain(host.substring(0, colonIndex));
                super.setHostPort(Integer.valueOf(host.substring(colonIndex + 1)));
            } else {
                super.setHostDomain(host);
                super.setHostPort(this.getProtocol().getDefaultPort());
            }
        } else {
            this.getLogger().info("Couldn't find the mandatory \"Host\" HTTP header.");
        }
        this.hostParsed = true;
    }

    protected void readRequestHead(InputStream headStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        int next = headStream.read();
        while (next != -1 && !HeaderUtils.isSpace(next)) {
            sb.append((char)next);
            next = headStream.read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the request method. End of stream reached too early.");
        }
        this.setMethod(sb.toString());
        sb.delete(0, sb.length());
        next = headStream.read();
        while (next != -1 && !HeaderUtils.isSpace(next)) {
            sb.append((char)next);
            next = headStream.read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the request URI. End of stream reached too early.");
        }
        this.setRequestUri(sb.toString());
        sb.delete(0, sb.length());
        next = headStream.read();
        while (next != -1 && !HeaderUtils.isCarriageReturn(next)) {
            sb.append((char)next);
            next = headStream.read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the HTTP version. End of stream reached too early.");
        }
        next = headStream.read();
        if (HeaderUtils.isLineFeed(next)) {
            this.setVersion(sb.toString());
            sb.delete(0, sb.length());
            Parameter header = HeaderReader.readHeader(headStream, sb);
            while (header != null) {
                this.getRequestHeaders().add(header);
                header = HeaderReader.readHeader(headStream, sb);
            }
        } else {
            throw new IOException("Unable to parse the HTTP version. The carriage return must be followed by a line feed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(Response response) throws IOException {
        if (response != null) {
            Representation responseEntity = response.getEntity();
            ConnectorService connectorService = ConnectorHelper.getConnectorService();
            if (connectorService != null) {
                connectorService.beforeSend(responseEntity);
            }
            try {
                this.writeResponseHead(response);
                if (responseEntity != null) {
                    OutputStream responseEntityStream = this.getResponseEntityStream();
                    this.writeResponseBody(responseEntity, responseEntityStream);
                    if (responseEntityStream != null) {
                        try {
                            responseEntityStream.flush();
                            responseEntityStream.close();
                        }
                        catch (IOException ioe) {
                            this.getLogger().log(Level.FINE, "Exception while flushing and closing the entity stream.", ioe);
                        }
                    }
                }
            }
            finally {
                if (responseEntity != null) {
                    responseEntity.release();
                }
                if (connectorService != null) {
                    connectorService.afterSend(responseEntity);
                }
            }
        }
    }

    public boolean shouldResponseBeChunked(Response response) {
        return response.getEntity() != null && response.getEntity().getSize() == -1L;
    }

    protected void writeResponseBody(Representation entity, OutputStream responseEntityStream) throws IOException {
        if (responseEntityStream != null) {
            entity.write(responseEntityStream);
            responseEntityStream.flush();
        }
    }

    protected void writeResponseHead(Response response) throws IOException {
    }

    protected void writeResponseHead(Response response, OutputStream headStream) throws IOException {
        String version = this.getVersion() == null ? "1.1" : this.getVersion();
        headStream.write(StringUtils.getAsciiBytes(version));
        headStream.write(32);
        headStream.write(StringUtils.getAsciiBytes(Integer.toString(this.getStatusCode())));
        headStream.write(32);
        if (this.getReasonPhrase() != null) {
            headStream.write(StringUtils.getLatin1Bytes(this.getReasonPhrase()));
        } else {
            headStream.write(StringUtils.getAsciiBytes("Status " + this.getStatusCode()));
        }
        headStream.write(13);
        headStream.write(10);
        this.getResponseHeaders().set("Connection", "close", true);
        if (this.shouldResponseBeChunked(response)) {
            this.getResponseHeaders().add("Transfer-Encoding", "chunked");
        }
        for (Parameter header : this.getResponseHeaders()) {
            HeaderUtils.writeHeaderLine(header, headStream);
        }
        headStream.write(13);
        headStream.write(10);
        headStream.flush();
    }
}

