/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.Buffer;
import org.restlet.engine.io.BufferState;
import org.restlet.engine.io.ChunkState;
import org.restlet.engine.io.CompletionListener;
import org.restlet.engine.io.ReadableBufferedChannel;
import org.restlet.engine.io.ReadableSelectionChannel;

public class ReadableChunkedChannel
extends ReadableBufferedChannel {
    private volatile ChunkState chunkState = ChunkState.SIZE;
    private final StringBuilder lineBuilder = new StringBuilder();
    private volatile BufferState lineBuilderState = BufferState.IDLE;
    private volatile int remainingChunkSize = 0;

    public ReadableChunkedChannel(CompletionListener completionListener, Buffer buffer, ReadableSelectionChannel source) {
        super(completionListener, buffer, source);
    }

    protected void clearLineBuilder() {
        this.getLineBuilder().delete(0, this.getLineBuilder().length());
        this.setLineBuilderState(BufferState.IDLE);
    }

    protected ChunkState getChunkState() {
        return this.chunkState;
    }

    protected StringBuilder getLineBuilder() {
        return this.lineBuilder;
    }

    protected BufferState getLineBuilderState() {
        return this.lineBuilderState;
    }

    protected int getRemainingChunkSize() {
        return this.remainingChunkSize;
    }

    public int onDrain(Buffer buffer, int maxDrained, Object ... args) throws IOException {
        int result = 0;
        ByteBuffer targetBuffer = (ByteBuffer)args[0];
        int before = buffer.remaining();
        if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
            Context.getCurrentLogger().log(Level.FINER, "Chunk state: " + (Object)((Object)this.getChunkState()));
        }
        switch (this.getChunkState()) {
            case SIZE: {
                this.setLineBuilderState(buffer.drain(this.getLineBuilder(), this.getLineBuilderState()));
                if (this.getLineBuilderState() != BufferState.DRAINING) break;
                int length = this.getLineBuilder().length();
                if (length == 0) {
                    throw new IOException("An empty chunk size line was detected");
                }
                int index = this.getLineBuilder().indexOf(";");
                index = index == -1 ? this.getLineBuilder().length() : index;
                try {
                    this.setRemainingChunkSize(Integer.parseInt(this.getLineBuilder().substring(0, index).trim(), 16));
                    if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                        Context.getCurrentLogger().log(Level.FINER, "New chunk detected. Size: " + this.remainingChunkSize);
                    }
                }
                catch (NumberFormatException ex) {
                    throw new IOException("\"" + this.getLineBuilder() + "\" has an invalid chunk size");
                }
                finally {
                    this.clearLineBuilder();
                }
                if (this.getRemainingChunkSize() == 0) {
                    this.setChunkState(ChunkState.TRAILER);
                    break;
                }
                this.setChunkState(ChunkState.DATA);
                break;
            }
            case DATA: {
                if (this.getRemainingChunkSize() > 0) {
                    result = super.onDrain(buffer, this.remainingChunkSize, targetBuffer);
                    if (result > 0) {
                        this.setRemainingChunkSize(this.getRemainingChunkSize() - result);
                    } else if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                        Context.getCurrentLogger().finer("No chunk data read");
                    }
                }
                if (this.getRemainingChunkSize() != 0) break;
                this.setLineBuilderState(buffer.drain(this.getLineBuilder(), this.getLineBuilderState()));
                if (this.getLineBuilderState() != BufferState.DRAINING) break;
                this.setChunkState(ChunkState.SIZE);
                this.clearLineBuilder();
                break;
            }
            case TRAILER: {
                this.setChunkState(ChunkState.END);
                break;
            }
            case END: {
                this.setLineBuilderState(buffer.drain(this.getLineBuilder(), this.getLineBuilderState()));
                if (this.getLineBuilderState() != BufferState.DRAINING) break;
                if (this.getLineBuilder().length() != 0) {
                    Context.getCurrentLogger().log(Level.FINE, "The last chunk line had a non empty line");
                }
                this.setEndReached(true);
            }
        }
        if (result != -1) {
            result = before - buffer.remaining();
        }
        return result;
    }

    protected void setChunkState(ChunkState chunkState) {
        this.chunkState = chunkState;
    }

    protected void setLineBuilderState(BufferState lineBuilderState) {
        this.lineBuilderState = lineBuilderState;
    }

    protected void setRemainingChunkSize(int remainingChunkSize) {
        this.remainingChunkSize = remainingChunkSize;
    }
}

