/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.connector.HttpInboundRequest;
import org.restlet.engine.connector.InboundRequest;
import org.restlet.engine.connector.ServerConnectionController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerConnectionHelper
extends ConnectionHelper<Server> {
    private volatile ServerSocketChannel serverSocketChannel;

    public ServerConnectionHelper(Server server) {
        super(server, false);
        this.getAttributes().put("ephemeralPort", -1);
    }

    protected abstract boolean canHandle(Connection<Server> var1, Response var2);

    @Override
    protected Connection<Server> createConnection(SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress) throws IOException {
        return new Connection<Server>(this, socketChannel, controller, socketAddress, this.getInboundBufferSize(), this.getOutboundBufferSize());
    }

    @Override
    protected ServerConnectionController createController() {
        return new ServerConnectionController(this);
    }

    protected Request createRequest(Connection<Server> connection, String methodName, String resourceUri, String version) {
        return new HttpInboundRequest(this.getContext(), connection, methodName, resourceUri, version);
    }

    protected ServerSocketChannel createServerSocketChannel() throws IOException {
        ServerSocketChannel result = ServerSocketChannel.open();
        ServerSocket socket = result.socket();
        socket.setReceiveBufferSize(this.getSocketReceiveBufferSize());
        socket.setReuseAddress(this.isSocketReuseAddress());
        socket.setSoTimeout(this.getMaxIoIdleTimeMs());
        socket.bind(this.createSocketAddress());
        result.configureBlocking(false);
        return result;
    }

    protected SocketAddress createSocketAddress() throws IOException {
        if (((Server)this.getHelped()).getAddress() == null) {
            return new InetSocketAddress(((Server)this.getHelped()).getPort());
        }
        return new InetSocketAddress(((Server)this.getHelped()).getAddress(), ((Server)this.getHelped()).getPort());
    }

    @Override
    public void doHandleInbound(Response response) {
        if (response != null && response.getRequest() != null) {
            this.getLogger().finer("Handling request...");
            this.handle(response.getRequest(), response);
            if (!response.isCommitted() && response.isAutoCommitting()) {
                response.setCommitted(true);
                this.getOutboundMessages().add(response);
            }
        }
    }

    @Override
    public void doHandleOutbound(Response response) {
        if (response != null) {
            this.getLogger().finer("Handling response...");
            InboundRequest request = (InboundRequest)((Object)response.getRequest());
            Connection<Server> connection = request.getConnection();
            if (response.getRequest().isExpectingResponse()) {
                if (this.canHandle(connection, response)) {
                    connection.getOutboundWay().handle(response);
                } else {
                    this.getOutboundMessages().add(response);
                }
            } else {
                this.getLogger().fine("A response for a request expecting no one was ignored");
            }
        }
    }

    @Override
    public ServerConnectionController getController() {
        return (ServerConnectionController)super.getController();
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        ((Server)this.getHelped()).handle(request, response);
    }

    @Override
    protected void handleInbound(Response response) {
        this.handleInbound(response, false);
    }

    @Override
    protected void handleOutbound(Response response) {
        this.handleOutbound(response, true);
    }

    @Override
    public boolean isControllerDaemon() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("controllerDaemon", "false"));
    }

    @Override
    public boolean isProxying() {
        return false;
    }

    public boolean isReuseAddress() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("reuseAddress", "true"));
    }

    public void setEphemeralPort(int localPort) {
        if (((Server)this.getHelped()).getPort() == 0) {
            this.getAttributes().put("ephemeralPort", localPort);
        }
    }

    public void setEphemeralPort(ServerSocket socket) {
        this.setEphemeralPort(socket.getLocalPort());
    }

    @Override
    public synchronized void start() throws Exception {
        this.getLogger().info("Starting the internal " + this.getProtocols() + " server on port " + ((Server)this.getHelped()).getPort());
        this.serverSocketChannel = this.createServerSocketChannel();
        this.setEphemeralPort(this.serverSocketChannel.socket());
        super.start();
        try {
            this.getController().await();
        }
        catch (InterruptedException ex) {
            this.getLogger().log(Level.WARNING, "Interrupted while waiting for starting latch. Stopping...", ex);
            this.stop();
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        this.getLogger().info("Stopping the internal " + this.getProtocols() + " server");
        super.stop();
        if (this.getServerSocketChannel() != null) {
            this.getServerSocketChannel().close();
        }
        this.getAttributes().put("ephemeralPort", -1);
    }
}

