/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.HttpServerInboundWay;
import org.restlet.engine.connector.HttpServerOutboundWay;
import org.restlet.engine.connector.OutboundWay;
import org.restlet.engine.connector.ServerConnectionHelper;
import org.restlet.engine.connector.ServerInboundWay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServerHelper
extends ServerConnectionHelper {
    public HttpServerHelper(Server server) {
        this(server, Protocol.HTTP);
    }

    public HttpServerHelper(Server server, Protocol protocol) {
        super(server);
        this.getProtocols().add(protocol);
    }

    @Override
    protected boolean canHandle(Connection<Server> connection, Response response) {
        HttpServerInboundWay inboundWay = (HttpServerInboundWay)connection.getInboundWay();
        Response nextResponse = inboundWay.getMessages().peek();
        return nextResponse != null && nextResponse.getRequest() == response.getRequest();
    }

    public ServerInboundWay createInboundWay(Connection<Server> connection, int bufferSize) {
        return new HttpServerInboundWay(connection, bufferSize);
    }

    @Override
    public OutboundWay createOutboundWay(Connection<Server> connection, int bufferSize) {
        return new HttpServerOutboundWay(connection, bufferSize);
    }
}

