/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.util.SelectionListener;

public class SelectionRegistration {
    private final CyclicBarrier barrier;
    private volatile SelectionListener listener;
    private volatile int interestOperations;
    private volatile int readyOperations;
    private volatile int previousInterest;
    private volatile boolean canceling = false;
    private final SelectableChannel selectableChannel;
    private volatile SelectionKey selectionKey;

    public static String getName(int operation) {
        switch (operation) {
            case 16: {
                return "ACCEPT";
            }
            case 8: {
                return "CONNECT";
            }
            case 1: {
                return "READ";
            }
            case 4: {
                return "WRITE";
            }
            case 0: {
                return "NONE";
            }
        }
        return Integer.toString(operation);
    }

    public SelectionRegistration(int interestOperations, SelectionListener listener) {
        this(null, interestOperations, listener);
    }

    public SelectionRegistration(SelectableChannel selectableChannel, int interestOperations, SelectionListener listener) {
        this.selectableChannel = selectableChannel;
        this.barrier = new CyclicBarrier(2);
        this.listener = listener;
        this.setInterestOperations(interestOperations);
    }

    public void addInterestOperations(int interest) {
        this.setInterestOperations(this.getInterestOperations() & interest);
    }

    public void block() {
        try {
            this.barrier.await(60000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getInterestOperations() {
        return this.interestOperations;
    }

    public SelectionListener getListener() {
        return this.listener;
    }

    public int getReadyOperations() {
        return this.readyOperations;
    }

    public SelectableChannel getSelectableChannel() {
        return this.selectableChannel;
    }

    public boolean isCanceling() {
        return this.canceling;
    }

    public boolean isConnectable() {
        return (this.getReadyOperations() & 8) != 0;
    }

    public boolean isReadable() {
        return (this.getReadyOperations() & 1) != 0;
    }

    public boolean isWritable() {
        return (this.getReadyOperations() & 4) != 0;
    }

    public void onSelected(int readyOperations) {
        this.readyOperations = readyOperations;
        if (this.getListener() != null && (this.getReadyOperations() & this.getInterestOperations()) != 0) {
            this.getListener().onSelected(this);
        }
    }

    public SelectionKey register(Selector selector) {
        try {
            this.selectionKey = this.getSelectableChannel().register(selector, this.getInterestOperations(), this);
        }
        catch (ClosedChannelException cce) {
            Context.getCurrentLogger().log(Level.INFO, "Unable to register again", cce);
        }
        return this.selectionKey;
    }

    public void resume() {
        this.setInterestOperations(this.previousInterest);
    }

    public void setCanceling(boolean canceling) {
        this.canceling = canceling;
    }

    public boolean setInterestOperations(int interest) {
        boolean result = this.interestOperations != interest;
        this.interestOperations = interest;
        this.setReadyOperations(0);
        return result;
    }

    public void setListener(SelectionListener listener) {
        this.listener = listener;
    }

    public void setReadInterest() {
        this.setInterestOperations(1);
    }

    public void setReadyOperations(int readyOperations) {
        this.readyOperations = readyOperations;
    }

    public void setWriteInterest() {
        this.setInterestOperations(4);
    }

    public void suspend() {
        this.previousInterest = this.getInterestOperations();
        this.setInterestOperations(0);
    }

    public String toString() {
        return SelectionRegistration.getName(this.getInterestOperations()) + ", " + SelectionRegistration.getName(this.getReadyOperations()) + ", " + Boolean.toString(this.isCanceling());
    }

    public void unblock() {
        try {
            if (this.barrier.getNumberWaiting() == 1) {
                this.barrier.await(60000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SelectionKey update() {
        if (this.selectionKey.isValid()) {
            if (this.isCanceling()) {
                Context.getCurrentLogger().log(Level.FINE, "Cancelling of the selection key requested");
                this.selectionKey.cancel();
            } else {
                try {
                    if (Context.getCurrentLogger().isLoggable(Level.FINE)) {
                        Context.getCurrentLogger().log(Level.FINE, "Update key (old | new) : " + SelectionRegistration.getName(this.selectionKey.interestOps()) + " | " + SelectionRegistration.getName(this.getInterestOperations()));
                    }
                    this.selectionKey.interestOps(this.getInterestOperations());
                }
                catch (CancelledKeyException cke) {
                    Context.getCurrentLogger().log(Level.FINE, "Unable to update a cancelled key, registering again", cke);
                    this.selectionKey = this.register(this.selectionKey.selector());
                }
            }
        } else {
            Context.getCurrentLogger().log(Level.FINE, "Invalid key detected, registering again");
            this.selectionKey = this.register(this.selectionKey.selector());
        }
        return this.selectionKey;
    }
}

