/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.restlet.engine.io.BlockableChannel;

public class InputStreamChannel
implements ReadableByteChannel,
BlockableChannel {
    private InputStream inputStream;
    private boolean blocking;
    private byte[] buffer = new byte[0];
    private volatile boolean open;

    public InputStreamChannel(InputStream inputStream) {
        this.inputStream = inputStream;
        this.open = true;
        try {
            this.blocking = inputStream.available() <= 0;
        }
        catch (IOException ioe) {
            this.blocking = true;
        }
    }

    public void close() throws IOException {
        this.getInputStream().close();
        this.open = false;
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public boolean isOpen() {
        return this.open;
    }

    public int read(ByteBuffer target) throws IOException {
        int result = 0;
        int available = this.getInputStream().available();
        if (!this.isBlocking()) {
            if (available > 0) {
                if (target.hasArray()) {
                    byte[] byteArray = target.array();
                    result = this.getInputStream().read(byteArray, target.position(), Math.min(available, target.remaining()));
                    if (result > 0) {
                        target.position(target.position() + result);
                    } else if (result == -1) {
                        target.position(target.position() + available);
                    }
                } else {
                    result = this.read(target, available);
                }
            } else {
                result = -1;
            }
        } else {
            result = this.read(target, 8192);
        }
        return result;
    }

    private int read(ByteBuffer target, int bytesToRead) throws IOException {
        int result = 0;
        if (this.buffer.length < 8192) {
            this.buffer = new byte[8192];
        }
        if ((result = this.getInputStream().read(this.buffer, 0, Math.min(bytesToRead, 8192))) > 0) {
            target.put(this.buffer, 0, result);
        }
        return result;
    }
}

