/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.restlet.engine.io.NioUtils;
import org.restlet.engine.io.SelectorFactory;

public class NbChannelInputStream
extends InputStream {
    private final ByteBuffer bb;
    private final ReadableByteChannel channel;
    private volatile boolean endReached;
    private final SelectableChannel selectableChannel;

    public NbChannelInputStream(ReadableByteChannel channel) {
        this.channel = channel;
        this.selectableChannel = channel instanceof SelectableChannel ? (SelectableChannel)((Object)channel) : null;
        this.bb = ByteBuffer.allocate(8192);
        this.bb.flip();
        this.endReached = false;
    }

    public int read() throws IOException {
        int result = -1;
        if (!this.endReached) {
            if (!this.bb.hasRemaining()) {
                this.refill();
            }
            if (!this.endReached) {
                result = this.bb.get() & 0xFF;
            }
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = -1;
        if (!this.endReached) {
            if (!this.bb.hasRemaining()) {
                this.refill();
            }
            if (!this.endReached) {
                result = Math.min(len, this.bb.remaining());
                this.bb.get(b, off, result);
            }
        }
        return result;
    }

    private int readChannel() throws IOException {
        int result = 0;
        this.bb.clear();
        result = this.channel.read(this.bb);
        this.bb.flip();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refill() throws IOException {
        Selector selector = null;
        SelectionKey selectionKey = null;
        try {
            int bytesRead = this.readChannel();
            if (bytesRead == 0 && this.selectableChannel != null) {
                selector = SelectorFactory.getSelector();
                if (selector != null) {
                    selectionKey = this.selectableChannel.register(selector, 1);
                    selector.select(60000L);
                }
                bytesRead = this.readChannel();
            } else if (bytesRead == -1) {
                this.endReached = true;
            }
        }
        catch (Throwable throwable) {
            NioUtils.release(selector, selectionKey);
            throw throwable;
        }
        NioUtils.release(selector, selectionKey);
    }
}

