/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.Digest;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.data.Range;
import org.restlet.data.Tag;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.util.DateUtils;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.RepresentationInfo;
import org.restlet.representation.Variant;

public abstract class Representation
extends RepresentationInfo {
    public static final long UNKNOWN_SIZE = -1L;
    private volatile boolean available;
    private volatile Digest digest;
    private volatile Disposition disposition;
    private volatile Date expirationDate;
    private volatile boolean isTransient;
    private volatile Range range;
    private volatile long size;

    @Deprecated
    public static Representation createEmpty() {
        return new EmptyRepresentation();
    }

    public Representation() {
        this(null);
    }

    public Representation(MediaType mediaType) {
        super(mediaType);
        this.available = true;
        this.disposition = null;
        this.isTransient = false;
        this.size = -1L;
        this.expirationDate = null;
        this.digest = null;
        this.range = null;
    }

    public Representation(MediaType mediaType, Date modificationDate) {
        this(mediaType, modificationDate, null);
    }

    public Representation(MediaType mediaType, Date modificationDate, Tag tag) {
        super(mediaType, modificationDate, tag);
    }

    public Representation(MediaType mediaType, Tag tag) {
        this(mediaType, null, tag);
    }

    public Representation(Variant variant, Date modificationDate) {
        this(variant, modificationDate, null);
    }

    public Representation(Variant variant, Date modificationDate, Tag tag) {
        this.setCharacterSet(variant.getCharacterSet());
        this.setEncodings(variant.getEncodings());
        this.setLocationRef(variant.getLocationRef());
        this.setLanguages(variant.getLanguages());
        this.setMediaType(variant.getMediaType());
        this.setModificationDate(modificationDate);
        this.setTag(tag);
    }

    public Representation(Variant variant, Tag tag) {
        this(variant, null, tag);
    }

    @Deprecated
    public boolean checkDigest() {
        return this.getDigest() != null && this.checkDigest(this.getDigest().getAlgorithm());
    }

    @Deprecated
    public boolean checkDigest(String algorithm) {
        Digest digest = this.getDigest();
        if (digest != null && algorithm.equals(digest.getAlgorithm())) {
            return digest.equals(this.computeDigest(algorithm));
        }
        return false;
    }

    @Deprecated
    public Digest computeDigest(String algorithm) {
        Digest result = null;
        if (this.isAvailable()) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                DigestInputStream dis = new DigestInputStream(this.getStream(), md);
                BioUtils.exhaust(dis);
                result = new Digest(algorithm, md.digest());
            }
            catch (NoSuchAlgorithmException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to check the digest of the representation.", e);
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to check the digest of the representation.", e);
            }
        }
        return result;
    }

    public long exhaust() throws IOException {
        long result = -1L;
        if (this.isAvailable()) {
            InputStream is = this.getStream();
            result = BioUtils.exhaust(is);
            is.close();
        }
        return result;
    }

    public long getAvailableSize() {
        return BioUtils.getAvailableSize(this);
    }

    public abstract ReadableByteChannel getChannel() throws IOException;

    public Digest getDigest() {
        return this.digest;
    }

    public Disposition getDisposition() {
        return this.disposition;
    }

    @Deprecated
    public String getDownloadName() {
        if (this.getDisposition() != null) {
            return this.getDisposition().getFilename();
        }
        return null;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public Range getRange() {
        return this.range;
    }

    public abstract Reader getReader() throws IOException;

    public long getSize() {
        return this.size;
    }

    public abstract InputStream getStream() throws IOException;

    public String getText() throws IOException {
        String result = null;
        if (this.isAvailable()) {
            if (this.getSize() == 0L) {
                result = "";
            } else {
                StringWriter sw = new StringWriter();
                this.write(sw);
                sw.flush();
                result = sw.toString();
            }
        }
        return result;
    }

    public boolean isAvailable() {
        return this.available && this.getSize() != 0L;
    }

    @Deprecated
    public boolean isDownloadable() {
        if (this.getDisposition() != null) {
            return !"inline".equalsIgnoreCase(this.getDisposition().getType());
        }
        return false;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void release() {
        this.setAvailable(false);
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setDigest(Digest digest) {
        this.digest = digest;
    }

    public void setDisposition(Disposition disposition) {
        this.disposition = disposition;
    }

    @Deprecated
    public void setDownloadable(boolean downloadable) {
        if (this.getDisposition() == null) {
            this.disposition = new Disposition();
        }
        this.disposition.setType(downloadable ? "attachment" : "none");
    }

    @Deprecated
    public void setDownloadName(String fileName) {
        if (this.getDisposition() == null) {
            this.disposition = new Disposition();
        }
        this.getDisposition().setFilename(fileName);
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = DateUtils.unmodifiable(expirationDate);
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setSize(long expectedSize) {
        this.size = expectedSize;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public abstract void write(Writer var1) throws IOException;

    public abstract void write(WritableByteChannel var1) throws IOException;

    public abstract void write(OutputStream var1) throws IOException;
}

