/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.resource.Finder;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerList
extends WrapperList<Server> {
    private volatile Context context;
    private volatile Restlet next;

    public ServerList(Context context, Restlet next) {
        super(new CopyOnWriteArrayList());
        this.context = context;
        this.next = next;
    }

    public Server add(Protocol protocol) {
        Server result = new Server(protocol, null, protocol.getDefaultPort(), this.getTarget());
        this.add(result);
        return result;
    }

    public Server add(Protocol protocol, int port) {
        Server result = new Server(protocol, null, port, this.getTarget());
        this.add(result);
        return result;
    }

    public Server add(Protocol protocol, String address, int port) {
        Server result = new Server(protocol, address, port, this.getTarget());
        this.add(result);
        return result;
    }

    @Override
    public boolean add(Server server) {
        if (server.getContext() == null) {
            server.setContext(this.getContext());
        }
        server.setNext(this.getTarget());
        return super.add(server);
    }

    public Context getContext() {
        return this.context;
    }

    public Restlet getNext() {
        return this.getTarget();
    }

    @Deprecated
    public Restlet getTarget() {
        return this.next;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setNext(Class<?> nextClass) {
        this.setTarget(new Finder(this.getContext(), nextClass));
    }

    public void setNext(Restlet next) {
        this.setTarget(next);
    }

    @Deprecated
    public void setTarget(Restlet next) {
        this.next = next;
    }
}

