/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.connector;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.Connector;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.engine.ConnectorHelper;
import org.restlet.engine.http.connector.Connection;
import org.restlet.engine.http.connector.ConnectionState;
import org.restlet.engine.http.connector.Controller;
import org.restlet.engine.log.LoggingThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseHelper<T extends Connector>
extends ConnectorHelper<T> {
    private final boolean clientSide;
    private final Set<Connection<T>> connections;
    private final Controller controller;
    private volatile ExecutorService controllerService;
    private final Queue<Response> inboundMessages;
    private final Queue<Response> outboundMessages;
    private volatile ThreadPoolExecutor workerService;

    public BaseHelper(T connector, boolean clientSide) {
        super(connector);
        this.clientSide = clientSide;
        this.connections = new CopyOnWriteArraySet<Connection<T>>();
        this.inboundMessages = new ConcurrentLinkedQueue<Response>();
        this.outboundMessages = new ConcurrentLinkedQueue<Response>();
        this.controller = this.createController();
    }

    protected abstract Connection<T> createConnection(BaseHelper<T> var1, Socket var2, SocketChannel var3) throws IOException;

    protected Controller createController() {
        return new Controller(this);
    }

    protected ExecutorService createControllerService() {
        return Executors.newSingleThreadExecutor(new LoggingThreadFactory(this.getLogger(), this.isControllerDaemon()));
    }

    protected Response createResponse(Request request) {
        return new Response(request);
    }

    protected ThreadPoolExecutor createWorkerService() {
        int maxThreads = this.getMaxThreads();
        int minThreads = this.getMinThreads();
        ThreadPoolExecutor result = new ThreadPoolExecutor(minThreads, maxThreads, (long)this.getThreadMaxIdleTimeMs(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new LoggingThreadFactory(this.getLogger(), true));
        result.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                BaseHelper.this.getLogger().warning("Unable to run the following " + (BaseHelper.this.isClientSide() ? "client-side" : "server-side") + " task: " + r);
                BaseHelper.this.getLogger().info("Worker service state: " + (BaseHelper.this.isWorkerServiceFull() ? "Full" : "Normal"));
                BaseHelper.this.getLogger().info("Worker service tasks: " + BaseHelper.this.getWorkerService().getQueue().size() + " queued, " + BaseHelper.this.getWorkerService().getActiveCount() + " active, " + BaseHelper.this.getWorkerService().getCompletedTaskCount() + " completed, " + BaseHelper.this.getWorkerService().getTaskCount() + " scheduled.");
                BaseHelper.this.getLogger().info("Worker service thread pool: " + BaseHelper.this.getWorkerService().getCorePoolSize() + " core size, " + BaseHelper.this.getWorkerService().getLargestPoolSize() + " largest size, " + BaseHelper.this.getWorkerService().getMaximumPoolSize() + " maximum size, " + BaseHelper.this.getWorkerService().getPoolSize() + " current size");
            }
        });
        return result;
    }

    protected Set<Connection<T>> getConnections() {
        return this.connections;
    }

    public Controller getController() {
        return this.controller;
    }

    public int getControllerSleepTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("controllerSleepTimeMs", "100"));
    }

    protected Queue<Response> getInboundMessages() {
        return this.inboundMessages;
    }

    public int getMaxConnectionsPerHost() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxConnectionsPerHost", "-1"));
    }

    public int getMaxThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxThreads", "255"));
    }

    public int getMaxTotalConnections() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxTotalConnections", "-1"));
    }

    public int getMinThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("minThreads", "1"));
    }

    protected Queue<Response> getOutboundMessages() {
        return this.outboundMessages;
    }

    public int getThreadMaxIdleTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("threadMaxIdleTimeMs", "60000"));
    }

    public ThreadPoolExecutor getWorkerService() {
        return this.workerService;
    }

    public abstract void handleInbound(Response var1);

    public void handleNextInbound() {
        this.handleInbound(this.getInboundMessages().poll());
    }

    protected void handleNextOutbound() {
        this.handleOutbound(this.getOutboundMessages().poll());
    }

    public abstract void handleOutbound(Response var1);

    public boolean isClientSide() {
        return this.clientSide;
    }

    public boolean isControllerDaemon() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("controllerDaemon", "true"));
    }

    public boolean isPersistingConnections() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("persistingConnections", "true"));
    }

    public boolean isPipeliningConnections() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("pipeliningConnections", "false"));
    }

    public boolean isServerSide() {
        return !this.isClientSide();
    }

    public boolean isTracing() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("tracing", "false"));
    }

    protected boolean isWorkerServiceFull() {
        return this.getWorkerService().getActiveCount() >= this.getWorkerService().getMaximumPoolSize();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.controllerService = this.createControllerService();
        this.workerService = this.createWorkerService();
        this.controllerService.submit(this.controller);
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        if (this.workerService != null) {
            this.workerService.shutdown();
        }
        for (Connection<T> connection : this.getConnections()) {
            connection.setState(ConnectionState.CLOSING);
            connection.setInboundBusy(false);
            connection.setOutboundBusy(false);
        }
        if (this.workerService != null) {
            try {
                this.workerService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                this.getLogger().log(Level.FINE, "Interruption while shutting down the worker service", ex);
            }
        }
        if (this.controllerService != null) {
            this.controller.setRunning(false);
            this.controllerService.shutdown();
            try {
                this.controllerService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                this.getLogger().log(Level.FINE, "Interruption while shutting down the controller service", ex);
            }
        }
    }
}

