/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInfo {
    private final java.lang.reflect.Method javaMethod;
    private final Method restletMethod;
    private final String value;

    public AnnotationInfo(Method restletMethod, java.lang.reflect.Method javaMethod, String value) {
        this.restletMethod = restletMethod;
        this.javaMethod = javaMethod;
        this.value = value;
    }

    public Class<?>[] getJavaInputTypes() {
        return this.getJavaMethod().getParameterTypes();
    }

    public java.lang.reflect.Method getJavaMethod() {
        return this.javaMethod;
    }

    public Class<?> getJavaOutputType() {
        return this.getJavaMethod().getReturnType();
    }

    public List<Variant> getRequestVariants(MetadataService metadataService) {
        ArrayList<Variant> result = null;
        String value = this.getValue();
        if (value != null) {
            String[] extensions;
            int colonIndex = value.indexOf(58);
            if (colonIndex != -1) {
                value = this.getValue().substring(0, colonIndex);
            }
            if (value != null && (extensions = value.split("\\|")) != null) {
                for (String extension : extensions) {
                    List<MediaType> mediaTypes = metadataService.getAllMediaTypes(extension);
                    if (mediaTypes == null) continue;
                    if (result == null) {
                        result = new ArrayList<Variant>();
                    }
                    for (MediaType mediaType : mediaTypes) {
                        result.add(new Variant(mediaType));
                    }
                }
            }
        }
        return result;
    }

    public List<Variant> getResponseVariants(Representation requestEntity, MetadataService metadataService, ConverterService converterService) {
        List<? extends Variant> result = null;
        String value = this.getValue();
        boolean compatibleRequestEntity = true;
        if (value != null) {
            int colonIndex = value.indexOf(58);
            if (colonIndex != -1) {
                value = this.getValue().substring(colonIndex + 1);
            }
            if (value != null) {
                List<Variant> requestVariants;
                if (requestEntity != null && (requestVariants = this.getRequestVariants(metadataService)) != null && !requestVariants.isEmpty()) {
                    compatibleRequestEntity = false;
                    for (int i = 0; !compatibleRequestEntity && i < requestVariants.size(); ++i) {
                        compatibleRequestEntity = requestVariants.get(i).isCompatible(requestEntity);
                    }
                }
                if (compatibleRequestEntity) {
                    String[] extensions;
                    for (String extension : extensions = value.split("\\|")) {
                        List<MediaType> mediaTypes = metadataService.getAllMediaTypes(extension);
                        if (mediaTypes == null) continue;
                        if (result == null) {
                            result = new ArrayList<Variant>();
                        }
                        for (MediaType mediaType : mediaTypes) {
                            result.add(new Variant(mediaType));
                        }
                    }
                }
            }
        }
        if (compatibleRequestEntity && result == null) {
            result = converterService.getVariants(this.getJavaOutputType(), null);
        }
        return result;
    }

    public Method getRestletMethod() {
        return this.restletMethod;
    }

    private String getValue() {
        return this.value;
    }
}

