/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Date;
import org.restlet.data.Disposition;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;

public class FileRepresentation
extends Representation {
    private volatile boolean autoDeleting;
    private volatile File file;

    private static File createFile(String path) {
        if (path.startsWith("file://")) {
            return new LocalReference(path).getFile();
        }
        return new File(path);
    }

    public FileRepresentation(File file, MediaType mediaType) {
        this(file, mediaType, -1);
    }

    public FileRepresentation(File file, MediaType mediaType, int timeToLive) {
        super(mediaType);
        this.file = file;
        this.setModificationDate(new Date(file.lastModified()));
        if (timeToLive == 0) {
            this.setExpirationDate(null);
        } else if (timeToLive > 0) {
            this.setExpirationDate(new Date(System.currentTimeMillis() + 1000L * (long)timeToLive));
        }
        this.setMediaType(mediaType);
        Disposition disposition = new Disposition();
        disposition.setFilename(file.getName());
        this.setDisposition(disposition);
    }

    public FileRepresentation(String path, MediaType mediaType) {
        this(path, mediaType, -1);
    }

    public FileRepresentation(String path, MediaType mediaType, int timeToLive) {
        this(FileRepresentation.createFile(path), mediaType, timeToLive);
    }

    public FileChannel getChannel() throws IOException {
        try {
            return new FileInputStream(this.file).getChannel();
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("Couldn't get the channel. File not found");
        }
    }

    public File getFile() {
        return this.file;
    }

    public Reader getReader() throws IOException {
        return new FileReader(this.file);
    }

    public long getSize() {
        if (super.getSize() != -1L) {
            return super.getSize();
        }
        return this.file.length();
    }

    public FileInputStream getStream() throws IOException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("Couldn't get the stream. File not found");
        }
    }

    public String getText() throws IOException {
        return BioUtils.toString(this.getStream(), this.getCharacterSet());
    }

    @Deprecated
    public boolean isAutoDelete() {
        return this.autoDeleting;
    }

    public boolean isAutoDeleting() {
        return this.isAutoDelete();
    }

    public void release() {
        if (this.isAutoDeleting() && this.getFile() != null) {
            try {
                BioUtils.delete(this.getFile(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setFile(null);
        super.release();
    }

    @Deprecated
    public void setAutoDelete(boolean autoDeleting) {
        this.autoDeleting = autoDeleting;
    }

    public void setAutoDeleting(boolean autoDeleting) {
        this.setAutoDelete(autoDeleting);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void write(OutputStream outputStream) throws IOException {
        BioUtils.copy((InputStream)this.getStream(), outputStream);
    }

    public void write(WritableByteChannel writableChannel) throws IOException {
        NioUtils.write(this.getChannel(), writableChannel);
    }

    public void write(Writer writer) throws IOException {
        BioUtils.copy(this.getReader(), writer);
    }
}

