/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.header;

import java.io.IOException;
import org.restlet.data.Warning;
import org.restlet.engine.http.header.HeaderUtils;
import org.restlet.engine.util.DateUtils;

public class WarningUtils {
    public static String format(Warning warning) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        try {
            WarningUtils.format(warning, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void format(Warning warning, Appendable destination) throws IllegalArgumentException, IOException {
        String agent = warning.getAgent();
        String text = warning.getText();
        if (warning.getStatus() == null) {
            throw new IllegalArgumentException("Can't write warning. Invalid status code detected");
        }
        if (agent == null || agent.length() == 0) {
            throw new IllegalArgumentException("Can't write warning. Invalid agent detected");
        }
        if (text == null || text.length() == 0) {
            throw new IllegalArgumentException("Can't write warning. Invalid text detected");
        }
        destination.append(Integer.toString(warning.getStatus().getCode()));
        destination.append(" ");
        destination.append(agent);
        destination.append(" ");
        HeaderUtils.appendQuote(text, destination);
        if (warning.getDate() != null) {
            HeaderUtils.appendQuote(DateUtils.format(warning.getDate()), destination);
        }
    }

    private WarningUtils() {
    }
}

