/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.header;

import java.io.IOException;
import org.restlet.data.Parameter;
import org.restlet.engine.http.header.HeaderUtils;

public class HeaderReader {
    private final String header;
    private volatile int index;

    public HeaderReader(String header) {
        this.header = header;
        this.index = header == null || header.length() == 0 ? -1 : 0;
    }

    public boolean isValueSeparator(int character) {
        return HeaderUtils.isValueSeparator(character);
    }

    public int read() {
        int result = -1;
        if (this.index != -1) {
            result = this.header.charAt(this.index++);
            if (this.index >= this.header.length()) {
                this.index = -1;
            }
        }
        return result;
    }

    public Parameter readParameter() throws IOException {
        Parameter result = null;
        boolean readingName = true;
        boolean readingValue = false;
        StringBuilder nameBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        int nextChar = 0;
        while (result == null && nextChar != -1) {
            nextChar = this.read();
            if (readingName) {
                if (HeaderUtils.isSpace(nextChar) && nameBuffer.length() == 0) continue;
                if (nextChar == -1 || nextChar == 44) {
                    if (nameBuffer.length() > 0) {
                        result = Parameter.create(nameBuffer, null);
                        continue;
                    }
                    if (nextChar == -1) continue;
                    throw new IOException("Empty parameter name detected. Please check your HTTP header");
                }
                if (nextChar == 61) {
                    readingName = false;
                    readingValue = true;
                    continue;
                }
                if (HeaderUtils.isTokenChar(nextChar)) {
                    nameBuffer.append((char)nextChar);
                    continue;
                }
                throw new IOException("Separator and control characters are not allowed within a token. Please check your HTTP header");
            }
            if (!readingValue || HeaderUtils.isSpace(nextChar) && valueBuffer.length() == 0) continue;
            if (nextChar == -1 || nextChar == 44) {
                result = Parameter.create(nameBuffer, valueBuffer);
                continue;
            }
            if (nextChar == 34 && valueBuffer.length() == 0) {
                valueBuffer.append(this.readQuotedString());
                continue;
            }
            if (HeaderUtils.isTokenChar(nextChar)) {
                valueBuffer.append((char)nextChar);
                continue;
            }
            throw new IOException("Separator and control characters are not allowed within a token. Please check your HTTP header");
        }
        return result;
    }

    public String readQuotedString() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.readQuotedString(sb);
        return sb.toString();
    }

    public void readQuotedString(Appendable buffer) throws IOException {
        boolean done = false;
        boolean quotedPair = false;
        int nextChar = 0;
        while (!done && nextChar != -1) {
            nextChar = this.read();
            if (quotedPair) {
                if (HeaderUtils.isText(nextChar)) {
                    buffer.append((char)nextChar);
                    quotedPair = false;
                    continue;
                }
                throw new IOException("Invalid character detected in quoted string. Please check your value");
            }
            if (HeaderUtils.isDoubleQuote(nextChar)) {
                done = true;
                continue;
            }
            if (nextChar == 92) {
                quotedPair = true;
                continue;
            }
            if (HeaderUtils.isText(nextChar)) {
                buffer.append((char)nextChar);
                continue;
            }
            throw new IOException("Invalid character detected in quoted string. Please check your value");
        }
    }

    public String readToken() {
        StringBuilder sb = null;
        int next = this.read();
        while (next != -1 && HeaderUtils.isLinearWhiteSpace(next)) {
            next = this.read();
        }
        while (next != -1 && HeaderUtils.isTokenChar(next)) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append((char)next);
            next = this.read();
        }
        return sb == null ? null : sb.toString();
    }

    public String readValue() {
        StringBuilder sb = null;
        int next = this.read();
        while (next != -1 && HeaderUtils.isLinearWhiteSpace(next)) {
            next = this.read();
        }
        while (next != -1 && !this.isValueSeparator(next)) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append((char)next);
            next = this.read();
        }
        if (sb != null) {
            for (int i = sb.length() - 1; i >= 0 && HeaderUtils.isLinearWhiteSpace(sb.charAt(i)); --i) {
                sb.deleteCharAt(i);
            }
        }
        return sb == null ? null : sb.toString();
    }
}

