/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.header;

import java.io.IOException;
import java.util.List;
import org.restlet.data.CacheDirective;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControlUtils {
    public static String format(List<CacheDirective> directives) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < directives.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            CacheDirective directive = directives.get(i);
            try {
                CacheControlUtils.format(directive, sb);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static void format(CacheDirective directive, Appendable destination) throws IOException {
        destination.append(directive.getName());
        if (directive.getValue() != null && directive.getValue().length() > 0) {
            if (directive.isDigit()) {
                destination.append("=").append(directive.getValue());
            } else {
                destination.append("=\"").append(directive.getValue()).append('\"');
            }
        }
    }
}

