/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Uniform;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.UniformResource;
import org.restlet.service.ConverterService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResource
extends UniformResource {
    private volatile boolean followingRedirects;
    private volatile Uniform next;
    private volatile int retryAttempts;
    private volatile long retryDelay;
    private volatile boolean retryOnError;

    public static <T> T create(Context context, Reference reference, Class<? extends T> resourceInterface) {
        ClientResource clientResource = new ClientResource(context, reference);
        return clientResource.wrap(resourceInterface);
    }

    public static <T> T create(Reference reference, Class<? extends T> resourceInterface) {
        return ClientResource.create(null, reference, resourceInterface);
    }

    public static <T> T create(String uri, Class<? extends T> resourceInterface) {
        return ClientResource.create(null, new Reference(uri), resourceInterface);
    }

    public ClientResource(Context context, URI uri) {
        this(context, Method.GET, uri);
    }

    public ClientResource(Context context, Method method, URI uri) {
        this(context, method, new Reference(uri));
    }

    public ClientResource(Context context, Method method, Reference reference) {
        Request request = new Request(method, reference);
        Response response = new Response(request);
        if (context == null) {
            context = Context.getCurrent();
        }
        if (context != null) {
            this.next = context.getClientDispatcher();
        }
        this.followingRedirects = true;
        this.retryOnError = true;
        this.retryDelay = 2000L;
        this.retryAttempts = 2;
        this.init(context, request, response);
    }

    public ClientResource(Context context, Method method, String uri) {
        this(context, method, new Reference(uri));
    }

    public ClientResource(Context context, Reference reference) {
        this(context, Method.GET, reference);
    }

    public ClientResource(Context context, Request request, Response response) {
        this.followingRedirects = true;
        this.init(context, request, response);
    }

    public ClientResource(Context context, String uri) {
        this(context, Method.GET, uri);
    }

    public ClientResource(URI uri) {
        this(Context.getCurrent(), null, uri);
    }

    public ClientResource(Method method, URI uri) {
        this(Context.getCurrent(), method, uri);
    }

    public ClientResource(Method method, Reference reference) {
        this(Context.getCurrent(), method, reference);
    }

    public ClientResource(Method method, String uri) {
        this(Context.getCurrent(), method, uri);
    }

    public ClientResource(Reference reference) {
        this(Context.getCurrent(), null, reference);
    }

    public ClientResource(Request request, Response response) {
        this(Context.getCurrent(), request, response);
    }

    public ClientResource(String uri) {
        this(Context.getCurrent(), null, uri);
    }

    public Representation delete() throws ResourceException {
        this.setMethod(Method.DELETE);
        Representation result = this.handle();
        if (this.getStatus().isError()) {
            throw new ResourceException(this.getStatus());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T delete(Class<T> resultClass) throws ResourceException {
        T result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        try {
            this.updateClientInfo(resultClass);
            result = this.toObject(this.delete(), resultClass);
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Representation delete(MediaType mediaType) throws ResourceException {
        Representation result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        ClientInfo newClientInfo = new ClientInfo();
        newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(mediaType));
        this.setClientInfo(newClientInfo);
        try {
            result = this.delete();
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    public Representation get() throws ResourceException {
        this.setMethod(Method.GET);
        Representation result = this.handle();
        if (this.getStatus().isError()) {
            throw new ResourceException(this.getStatus());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Class<T> resultClass) throws ResourceException {
        T result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        try {
            this.updateClientInfo(resultClass);
            result = this.toObject(this.get(), resultClass);
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Representation get(MediaType mediaType) throws ResourceException {
        Representation result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        ClientInfo newClientInfo = new ClientInfo();
        newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(mediaType));
        this.setClientInfo(newClientInfo);
        try {
            result = this.get();
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    public Uniform getNext() {
        return this.next;
    }

    public Uniform getOnContinue() {
        return this.getRequest().getOnContinue();
    }

    public Uniform getOnReceived() {
        return this.getResponse().getOnReceived();
    }

    public Uniform getOnSent() {
        return this.getRequest().getOnSent();
    }

    public ClientResource getParent() throws ResourceException {
        ClientResource result = null;
        if (!this.getReference().isHierarchical()) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "The resource URI is not hierarchical.");
        }
        Reference parentRef = this.getReference().getParentRef();
        result = new ClientResource(parentRef);
        return result;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    @Override
    public Representation handle() {
        Representation result = null;
        if (!this.hasNext()) {
            Protocol protocol;
            Protocol protocol2 = protocol = this.getReference() == null ? null : this.getReference().getSchemeProtocol();
            if (protocol != null) {
                this.setNext(new Client(protocol));
            }
        }
        if (this.hasNext()) {
            this.handle(this.getRequest(), this.getResponse(), null, 0);
            result = this.getResponse().getEntity();
        } else {
            this.getLogger().warning("Unable to process the call for a client resource. No next Restlet has been provided.");
        }
        return result;
    }

    private void handle(Request request, Response response, List<Reference> references, int retryAttempt) {
        this.getNext().handle(request, response);
        if (this.isFollowingRedirects() && response.getStatus().isRedirection() && response.getLocationRef() != null) {
            boolean doRedirection = false;
            if (request.getMethod().isSafe()) {
                doRedirection = true;
            } else if (Status.REDIRECTION_SEE_OTHER.equals(response.getStatus())) {
                request.setMethod(Method.GET);
                request.setEntity(null);
                doRedirection = true;
            } else if (Status.REDIRECTION_USE_PROXY.equals(response.getStatus())) {
                doRedirection = true;
            }
            if (doRedirection) {
                Reference newTargetRef = response.getLocationRef();
                if (references != null && references.contains(newTargetRef)) {
                    this.getLogger().warning("Infinite redirection loop detected with URI: " + newTargetRef);
                } else if (request.getEntity() != null && !request.isEntityAvailable()) {
                    this.getLogger().warning("Unable to follow the redirection because the request entity isn't available anymore.");
                } else {
                    if (references == null) {
                        references = new ArrayList<Reference>();
                    }
                    references.add(request.getResourceRef());
                    request.setResourceRef(newTargetRef);
                    this.handle(request, response, references, 0);
                }
            }
        } else if (this.isRetryOnError() && response.getStatus().isRecoverableError() && request.getMethod().isIdempotent() && retryAttempt < this.getRetryAttempts() && (this.getRequestEntity() == null || this.getRequestEntity().isAvailable())) {
            this.getLogger().log(Level.INFO, "A recoverable error was detected (" + response.getStatus().getCode() + "), attempting again in " + this.getRetryDelay() + " ms.");
            if (this.getRetryDelay() > 0L) {
                try {
                    Thread.sleep(this.getRetryDelay());
                }
                catch (InterruptedException e) {
                    this.getLogger().log(Level.FINE, "Retry delay sleep was interrupted", e);
                }
            }
            this.handle(request, response, references, ++retryAttempt);
        }
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    public Representation head() throws ResourceException {
        this.setMethod(Method.HEAD);
        Representation result = this.handle();
        if (this.getStatus().isError()) {
            throw new ResourceException(this.getStatus());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Representation head(MediaType mediaType) throws ResourceException {
        Representation result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        ClientInfo newClientInfo = new ClientInfo();
        newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(mediaType));
        this.setClientInfo(newClientInfo);
        try {
            result = this.head();
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    public boolean isFollowingRedirects() {
        return this.followingRedirects;
    }

    public boolean isRetryOnError() {
        return this.retryOnError;
    }

    public Representation options() throws ResourceException {
        this.setMethod(Method.OPTIONS);
        Representation result = this.handle();
        if (this.getStatus().isError()) {
            throw new ResourceException(this.getStatus());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T options(Class<T> resultClass) throws ResourceException {
        T result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        try {
            this.updateClientInfo(resultClass);
            result = this.toObject(this.options(), resultClass);
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Representation options(MediaType mediaType) throws ResourceException {
        Representation result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        ClientInfo newClientInfo = new ClientInfo();
        newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(mediaType));
        this.setClientInfo(newClientInfo);
        try {
            result = this.options();
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    public Representation post(Object entity) throws ResourceException {
        return this.post(this.toRepresentation(entity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T post(Object entity, Class<T> resultClass) throws ResourceException {
        T result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        try {
            this.updateClientInfo(resultClass);
            result = this.toObject(this.post(this.toRepresentation(entity)), resultClass);
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Representation post(Object entity, MediaType mediaType) throws ResourceException {
        Representation result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        ClientInfo newClientInfo = new ClientInfo();
        newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(mediaType));
        this.setClientInfo(newClientInfo);
        try {
            result = this.post(this.toRepresentation(entity));
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    public Representation post(Representation entity) throws ResourceException {
        this.setMethod(Method.POST);
        this.getRequest().setEntity(entity);
        Representation result = this.handle();
        if (this.getStatus().isError()) {
            throw new ResourceException(this.getStatus());
        }
        return result;
    }

    public Representation put(Object entity) throws ResourceException {
        return this.put(this.toRepresentation(entity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T put(Object entity, Class<T> resultClass) throws ResourceException {
        T result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        try {
            this.updateClientInfo(resultClass);
            result = this.toObject(this.put(this.toRepresentation(entity)), resultClass);
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Representation put(Object entity, MediaType mediaType) throws ResourceException {
        Representation result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        ClientInfo newClientInfo = new ClientInfo();
        newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(mediaType));
        this.setClientInfo(newClientInfo);
        try {
            result = this.put(this.toRepresentation(entity));
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    public Representation put(Representation representation) throws ResourceException {
        this.setMethod(Method.PUT);
        this.getRequest().setEntity(representation);
        Representation result = this.handle();
        if (this.getStatus().isError()) {
            throw new ResourceException(this.getStatus());
        }
        return result;
    }

    public void setChallengeResponse(ChallengeResponse challengeResponse) {
        this.getRequest().setChallengeResponse(challengeResponse);
    }

    public void setChallengeResponse(ChallengeScheme scheme, String identifier, String secret) {
        this.setChallengeResponse(new ChallengeResponse(scheme, identifier, secret));
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.getRequest().setClientInfo(clientInfo);
    }

    public void setConditions(Conditions conditions) {
        this.getRequest().setConditions(conditions);
    }

    public void setCookies(Series<Cookie> cookies) {
        this.getRequest().setCookies(cookies);
    }

    public void setFollowingRedirects(boolean followingRedirects) {
        this.followingRedirects = followingRedirects;
    }

    public void setHostRef(Reference hostRef) {
        this.getRequest().setHostRef(hostRef);
    }

    public void setHostRef(String hostUri) {
        this.getRequest().setHostRef(hostUri);
    }

    public void setMethod(Method method) {
        this.getRequest().setMethod(method);
    }

    public void setNext(Uniform next) {
        Restlet nextRestlet;
        if (next instanceof Restlet && (nextRestlet = (Restlet)next).getContext() == null) {
            nextRestlet.setContext(this.getContext());
        }
        this.next = next;
    }

    public void setOnContinue(Uniform onContinueCallback) {
        this.getRequest().setOnContinue(onContinueCallback);
    }

    public void setOnReceived(Uniform onReceivedCallback) {
        this.getResponse().setOnReceived(onReceivedCallback);
    }

    public void setOnSent(Uniform onSentCallback) {
        this.getRequest().setOnSent(onSentCallback);
    }

    public void setOriginalRef(Reference originalRef) {
        this.getRequest().setOriginalRef(originalRef);
    }

    public void setRanges(List<Range> ranges) {
        this.getRequest().setRanges(ranges);
    }

    public void setReference(Reference reference) {
        this.getRequest().setResourceRef(reference);
    }

    public void setReference(String uri) {
        this.getRequest().setResourceRef(uri);
    }

    public void setReferrerRef(Reference referrerRef) {
        this.getRequest().setReferrerRef(referrerRef);
    }

    public void setReferrerRef(String referrerUri) {
        this.getRequest().setReferrerRef(referrerUri);
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public void setRetryOnError(boolean retryOnError) {
        this.retryOnError = retryOnError;
    }

    protected <T> T toObject(Representation source, Class<T> target) throws ResourceException {
        T result = null;
        if (source != null) {
            try {
                ConverterService cs = this.getConverterService();
                result = cs.toObject(source, target, this);
            }
            catch (Exception e) {
                throw new ResourceException(e);
            }
        }
        return result;
    }

    protected Representation toRepresentation(Object source) {
        Representation result = null;
        if (source != null) {
            ConverterService cs = this.getConverterService();
            result = cs.toRepresentation(source);
        }
        return result;
    }

    private <T> void updateClientInfo(Class<T> resultClass) {
        ConverterService cs = this.getConverterService();
        this.updateClientInfo(cs.getVariants(resultClass, null));
    }

    private <T> void updateClientInfo(List<? extends Variant> variants) {
        ClientInfo newClientInfo = new ClientInfo();
        if (variants != null) {
            for (Variant variant : variants) {
                newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(variant.getMediaType()));
            }
        }
        this.setClientInfo(newClientInfo);
    }

    public <T> T wrap(Class<? extends T> resourceInterface) {
        Object result = null;
        final List<AnnotationInfo> annotations = AnnotationUtils.getAnnotationDescriptors(resourceInterface);
        InvocationHandler h = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, java.lang.reflect.Method javaMethod, Object[] args) throws Throwable {
                Object result = null;
                AnnotationInfo annotation = AnnotationUtils.getAnnotation((List<AnnotationInfo>)annotations, javaMethod);
                if (annotation != null) {
                    ClientInfo currentClientInfo = ClientResource.this.getClientInfo();
                    try {
                        List<Variant> responseVariants;
                        Representation requestEntity = null;
                        if (args != null && args.length > 0) {
                            requestEntity = ClientResource.this.toRepresentation(args[0]);
                            ClientResource.this.getRequest().setEntity(requestEntity);
                        }
                        if ((responseVariants = annotation.getResponseVariants(requestEntity, ClientResource.this.getMetadataService(), ClientResource.this.getConverterService())) != null) {
                            ClientResource.this.updateClientInfo(responseVariants);
                        }
                        ClientResource.this.setMethod(annotation.getRestletMethod());
                        ClientResource.this.handle();
                        if (ClientResource.this.getStatus().isError()) {
                            throw new ResourceException(ClientResource.this.getStatus());
                        }
                        if (annotation.getJavaOutputType() != null) {
                            result = ClientResource.this.toObject(ClientResource.this.getResponseEntity(), annotation.getJavaOutputType());
                        }
                    }
                    finally {
                        ClientResource.this.setClientInfo(currentClientInfo);
                    }
                }
                return result;
            }
        };
        result = Proxy.newProxyInstance(Engine.getClassLoader(), new Class[]{resourceInterface}, h);
        return (T)result;
    }
}

